/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.microsoft.bot.connector.authentication.AuthenticationConfiguration;
import com.microsoft.bot.connector.authentication.AuthenticationConstants;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.ChannelProvider;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.connector.authentication.JwtTokenExtractor;
import com.microsoft.bot.connector.authentication.TokenValidationParameters;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public final class EmulatorValidation {
    private EmulatorValidation() {
    }

    public static TokenValidationParameters getTokenValidationParameters() {
        TokenValidationParameters tokenValidationParameters = new TokenValidationParameters();
        tokenValidationParameters.validateIssuer = true;
        ArrayList<String> validIssuers = new ArrayList<String>();
        validIssuers.add("https://sts.windows.net/d6d49420-f39b-4df7-a1dc-d59a935871db/");
        validIssuers.add("https://login.microsoftonline.com/d6d49420-f39b-4df7-a1dc-d59a935871db/v2.0");
        validIssuers.add("https://sts.windows.net/f8cdef31-a31e-4b4a-93e4-5f571e91255a/");
        validIssuers.add("https://login.microsoftonline.com/f8cdef31-a31e-4b4a-93e4-5f571e91255a/v2.0");
        validIssuers.add("https://sts.windows.net/cab8a31a-1906-4287-a0d8-4eef66b95f6e/");
        validIssuers.add("https://login.microsoftonline.us/cab8a31a-1906-4287-a0d8-4eef66b95f6e/v2.0");
        tokenValidationParameters.validIssuers = validIssuers;
        tokenValidationParameters.validateAudience = false;
        tokenValidationParameters.validateLifetime = true;
        tokenValidationParameters.clockSkew = Duration.ofMinutes(5L);
        tokenValidationParameters.requireSignedTokens = true;
        return tokenValidationParameters;
    }

    public static Boolean isTokenFromEmulator(String authHeader) {
        if (StringUtils.isEmpty((CharSequence)authHeader)) {
            return false;
        }
        String[] parts = authHeader.split(" ");
        if (parts.length != 2) {
            return false;
        }
        String schema = parts[0];
        String token = parts[1];
        if (!schema.equalsIgnoreCase("bearer")) {
            return false;
        }
        try {
            DecodedJWT decodedJWT = JWT.decode((String)token);
            if (StringUtils.isEmpty((CharSequence)decodedJWT.getIssuer())) {
                return false;
            }
            return EmulatorValidation.getTokenValidationParameters().validIssuers.contains(decodedJWT.getIssuer());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, ChannelProvider channelProvider, String channelId) {
        return EmulatorValidation.authenticateToken(authHeader, credentials, channelProvider, channelId, new AuthenticationConfiguration());
    }

    public static CompletableFuture<ClaimsIdentity> authenticateToken(String authHeader, CredentialProvider credentials, ChannelProvider channelProvider, String channelId, AuthenticationConfiguration authConfig) {
        String openIdMetadataUrl = channelProvider != null && channelProvider.isGovernment() ? "https://login.microsoftonline.us/cab8a31a-1906-4287-a0d8-4eef66b95f6e/v2.0/.well-known/openid-configuration" : "https://login.microsoftonline.com/common/v2.0/.well-known/openid-configuration";
        JwtTokenExtractor tokenExtractor = new JwtTokenExtractor(EmulatorValidation.getTokenValidationParameters(), openIdMetadataUrl, AuthenticationConstants.ALLOWED_SIGNING_ALGORITHMS);
        return tokenExtractor.getIdentity(authHeader, channelId, authConfig.requiredEndorsements()).thenCompose(identity -> {
            String appId;
            if (identity == null) {
                throw new AuthenticationException("Invalid Identity");
            }
            if (!identity.isAuthenticated()) {
                throw new AuthenticationException("Token Not Authenticated");
            }
            if (!identity.claims().containsKey("ver")) {
                throw new AuthenticationException(String.format("'%s' claim is required on Emulator Tokens.", "ver"));
            }
            String tokenVersion = identity.claims().get("ver");
            if (StringUtils.isEmpty((CharSequence)tokenVersion) || tokenVersion.equalsIgnoreCase("1.0")) {
                if (!identity.claims().containsKey("appid")) {
                    throw new AuthenticationException(String.format("'%s' claim is required on Emulator Token version '1.0'.", "appid"));
                }
                appId = identity.claims().get("appid");
            } else if (tokenVersion.equalsIgnoreCase("2.0")) {
                if (!identity.claims().containsKey("azp")) {
                    throw new AuthenticationException(String.format("'%s' claim is required on Emulator Token version '2.0'.", "azp"));
                }
                appId = identity.claims().get("azp");
            } else {
                throw new AuthenticationException(String.format("Unknown Emulator Token version '%s'.", tokenVersion));
            }
            return credentials.isValidAppId(appId).thenApply(isValid -> {
                if (!isValid.booleanValue()) {
                    throw new AuthenticationException(String.format("Invalid AppId passed on token: '%s'.", appId));
                }
                return identity;
            });
        });
    }
}

