/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector;

import com.microsoft.bot.connector.Async;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.AttachmentData;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.ConversationParameters;
import com.microsoft.bot.schema.ConversationResourceResponse;
import com.microsoft.bot.schema.ConversationsResult;
import com.microsoft.bot.schema.PagedMembersResult;
import com.microsoft.bot.schema.ResourceResponse;
import com.microsoft.bot.schema.Transcript;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public interface Conversations {
    public CompletableFuture<ConversationsResult> getConversations();

    public CompletableFuture<ConversationsResult> getConversations(String var1);

    public CompletableFuture<ConversationResourceResponse> createConversation(ConversationParameters var1);

    public CompletableFuture<ResourceResponse> sendToConversation(String var1, Activity var2);

    default public CompletableFuture<ResourceResponse> sendToConversation(Activity activity) {
        return this.sendToConversation(activity.getConversation().getId(), activity);
    }

    public CompletableFuture<ResourceResponse> updateActivity(String var1, String var2, Activity var3);

    default public CompletableFuture<ResourceResponse> updateActivity(Activity activity) {
        return this.updateActivity(activity.getConversation().getId(), activity.getId(), activity);
    }

    public CompletableFuture<ResourceResponse> replyToActivity(String var1, String var2, Activity var3);

    default public CompletableFuture<ResourceResponse> replyToActivity(Activity activity) {
        if (StringUtils.isEmpty((CharSequence)activity.getReplyToId())) {
            return Async.completeExceptionally(new IllegalArgumentException("ReplyToId cannot be empty"));
        }
        return this.replyToActivity(activity.getConversation().getId(), activity.getReplyToId(), activity);
    }

    public CompletableFuture<Void> deleteActivity(String var1, String var2);

    public CompletableFuture<List<ChannelAccount>> getConversationMembers(String var1);

    public CompletableFuture<ChannelAccount> getConversationMember(String var1, String var2);

    public CompletableFuture<Void> deleteConversationMember(String var1, String var2);

    public CompletableFuture<List<ChannelAccount>> getActivityMembers(String var1, String var2);

    public CompletableFuture<ResourceResponse> uploadAttachment(String var1, AttachmentData var2);

    public CompletableFuture<ResourceResponse> sendConversationHistory(String var1, Transcript var2);

    public CompletableFuture<PagedMembersResult> getConversationPagedMembers(String var1);

    public CompletableFuture<PagedMembersResult> getConversationPagedMembers(String var1, String var2);
}

