/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder.teams;

import com.microsoft.bot.builder.InvokeResponse;
import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.NextDelegate;
import com.microsoft.bot.builder.Storage;
import com.microsoft.bot.builder.StoreItem;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.builder.UserTokenProvider;
import com.microsoft.bot.connector.rest.RestOAuthClient;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.Serialization;
import com.microsoft.bot.schema.TokenExchangeInvokeRequest;
import com.microsoft.bot.schema.TokenExchangeInvokeResponse;
import com.microsoft.bot.schema.TokenExchangeRequest;
import com.microsoft.bot.schema.TokenResponse;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class TeamsSSOTokenExchangeMiddleware
implements Middleware {
    private final Storage storage;
    private final String oAuthConnectionName;

    public TeamsSSOTokenExchangeMiddleware(Storage storage, String connectionName) {
        if (storage == null) {
            throw new IllegalArgumentException("storage cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)connectionName)) {
            throw new IllegalArgumentException("connectionName cannot be null.");
        }
        this.oAuthConnectionName = connectionName;
        this.storage = storage;
    }

    @Override
    public CompletableFuture<Void> onTurn(TurnContext turnContext, NextDelegate next) {
        if (turnContext.getActivity() != null && turnContext.getActivity().getName() != null && turnContext.getActivity().getName().equals("signin/tokenExchange")) {
            if (!this.exchangedToken(turnContext).join().booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            if (!this.deDuplicatedTokenExchangeId(turnContext).join().booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
        }
        return next.next();
    }

    private CompletableFuture<Boolean> deDuplicatedTokenExchangeId(TurnContext turnContext) {
        block3: {
            String idValue = null;
            TokenStoreItem storeItem = new TokenStoreItem();
            TokenExchangeInvokeRequest tokenExchangeRequest = (TokenExchangeInvokeRequest)Serialization.getAs((Object)turnContext.getActivity().getValue(), TokenExchangeInvokeRequest.class);
            if (tokenExchangeRequest != null) {
                idValue = tokenExchangeRequest.getId();
            }
            storeItem.setETag(idValue);
            HashMap<String, Object> storeItems = new HashMap<String, Object>();
            storeItems.put(storeItem.getStorageKey(turnContext), storeItem);
            try {
                this.storage.write(storeItems).join();
            }
            catch (Exception ex) {
                if (!ex.getMessage().contains("eTag conflict") && !ex.getMessage().contains("precondition is not met")) break block3;
                return this.sendInvokeResponse(turnContext, null, 200).thenApply(result -> false);
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    private CompletableFuture<Void> sendInvokeResponse(TurnContext turnContext, Object body, int statusCode) {
        Activity activity = new Activity("invokeResponse");
        InvokeResponse response = new InvokeResponse(statusCode, body);
        activity.setValue((Object)response);
        return turnContext.sendActivity(activity).thenApply(result -> null);
    }

    private CompletableFuture<Boolean> exchangedToken(TurnContext turnContext) {
        TokenExchangeInvokeRequest tokenExchangeRequest;
        TokenResponse tokenExchangeResponse;
        block5: {
            tokenExchangeResponse = null;
            tokenExchangeRequest = (TokenExchangeInvokeRequest)Serialization.getAs((Object)turnContext.getActivity().getValue(), TokenExchangeInvokeRequest.class);
            try {
                RestOAuthClient userTokenClient = turnContext.getTurnState().get(RestOAuthClient.class);
                TokenExchangeRequest exchangeRequest = new TokenExchangeRequest();
                exchangeRequest.setToken(tokenExchangeRequest.getToken());
                if (userTokenClient != null) {
                    tokenExchangeResponse = (TokenResponse)userTokenClient.getUserToken().exchangeToken(turnContext.getActivity().getFrom().getId(), this.oAuthConnectionName, turnContext.getActivity().getChannelId(), exchangeRequest).join();
                    break block5;
                }
                if (turnContext.getAdapter() instanceof UserTokenProvider) {
                    UserTokenProvider adapter = (UserTokenProvider)((Object)turnContext.getAdapter());
                    tokenExchangeResponse = adapter.exchangeToken(turnContext, this.oAuthConnectionName, turnContext.getActivity().getFrom().getId(), exchangeRequest).join();
                    break block5;
                }
                throw new RuntimeException("Token Exchange is not supported by the current adapter.");
            }
            catch (Exception userTokenClient) {
                // empty catch block
            }
        }
        if (tokenExchangeResponse != null && StringUtils.isEmpty((CharSequence)tokenExchangeResponse.getToken())) {
            TokenExchangeInvokeResponse invokeResponse = new TokenExchangeInvokeResponse();
            invokeResponse.setId(tokenExchangeRequest.getId());
            invokeResponse.setConnectionName(this.oAuthConnectionName);
            invokeResponse.setFailureDetail("The bot is unable to exchange token. Proceed with regular login.");
            this.sendInvokeResponse(turnContext, invokeResponse, 412);
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.completedFuture(true);
    }

    private class TokenStoreItem
    implements StoreItem {
        private String etag;

        private TokenStoreItem() {
        }

        @Override
        public String getETag() {
            return this.etag;
        }

        @Override
        public void setETag(String withETag) {
            this.etag = withETag;
        }

        public String getStorageKey(TurnContext turnContext) {
            Activity activity = turnContext.getActivity();
            if (activity.getChannelId() == null) {
                throw new RuntimeException("invalid activity-missing channelId");
            }
            if (activity.getConversation() == null || activity.getConversation().getId() == null) {
                throw new RuntimeException("invalid activity-missing Conversation.Id");
            }
            String channelId = activity.getChannelId();
            String conversationId = activity.getConversation().getId();
            TokenExchangeInvokeRequest tokenExchangeRequest = (TokenExchangeInvokeRequest)Serialization.getAs((Object)turnContext.getActivity().getValue(), TokenExchangeInvokeRequest.class);
            if (tokenExchangeRequest != null) {
                return String.format("%s/%s/%s", channelId, conversationId, tokenExchangeRequest.getId());
            }
            throw new RuntimeException("Invalid signin/tokenExchange. Missing activity.getValue().getId().");
        }
    }
}

