/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder.teams;

import com.microsoft.bot.builder.BotFrameworkAdapter;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.connector.ConnectorClient;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.bot.connector.rest.RestTeamsConnectorClient;
import com.microsoft.bot.connector.teams.TeamsConnectorClient;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ConversationParameters;
import com.microsoft.bot.schema.ConversationReference;
import com.microsoft.bot.schema.Pair;
import com.microsoft.bot.schema.Serialization;
import com.microsoft.bot.schema.teams.ChannelInfo;
import com.microsoft.bot.schema.teams.ConversationList;
import com.microsoft.bot.schema.teams.MeetingInfo;
import com.microsoft.bot.schema.teams.TeamDetails;
import com.microsoft.bot.schema.teams.TeamsChannelAccount;
import com.microsoft.bot.schema.teams.TeamsChannelData;
import com.microsoft.bot.schema.teams.TeamsMeetingParticipant;
import com.microsoft.bot.schema.teams.TeamsPagedMembersResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class TeamsInfo {
    private TeamsInfo() {
    }

    public static CompletableFuture<TeamDetails> getTeamDetails(TurnContext turnContext, String teamId) {
        String effectiveTeamId;
        String string = effectiveTeamId = teamId != null ? teamId : turnContext.getActivity().teamsGetTeamId();
        if (effectiveTeamId == null) {
            return TeamsInfo.illegalArgument("This method is only valid within the scope of MS Teams Team.");
        }
        return TeamsInfo.getTeamsConnectorClient(turnContext).getTeams().fetchTeamDetails(effectiveTeamId);
    }

    public static CompletableFuture<List<ChannelInfo>> getTeamChannels(TurnContext turnContext, String teamId) {
        String effectiveTeamId;
        String string = effectiveTeamId = teamId != null ? teamId : turnContext.getActivity().teamsGetTeamId();
        if (effectiveTeamId == null) {
            return TeamsInfo.illegalArgument("This method is only valid within the scope of MS Teams Team.");
        }
        return TeamsInfo.getTeamsConnectorClient(turnContext).getTeams().fetchChannelList(effectiveTeamId).thenApply(ConversationList::getConversations);
    }

    public static CompletableFuture<List<TeamsChannelAccount>> getTeamMembers(TurnContext turnContext, String teamId) {
        String effectiveTeamId;
        String string = effectiveTeamId = teamId != null ? teamId : turnContext.getActivity().teamsGetTeamId();
        if (effectiveTeamId == null) {
            return TeamsInfo.illegalArgument("This method is only valid within the scope of MS Teams Team.");
        }
        return TeamsInfo.getMembers(TeamsInfo.getConnectorClient(turnContext), effectiveTeamId);
    }

    public static CompletableFuture<TeamsChannelAccount> getTeamMember(TurnContext turnContext, String userId, String teamId) {
        String effectiveTeamId;
        String string = effectiveTeamId = teamId != null ? teamId : turnContext.getActivity().teamsGetTeamId();
        if (effectiveTeamId == null) {
            return TeamsInfo.illegalArgument("This method is only valid within the scope of MS Teams Team.");
        }
        return TeamsInfo.getMember(TeamsInfo.getConnectorClient(turnContext), userId, effectiveTeamId);
    }

    public static CompletableFuture<List<TeamsChannelAccount>> getMembers(TurnContext turnContext) {
        String teamId = turnContext.getActivity().teamsGetTeamId();
        if (!StringUtils.isEmpty((CharSequence)teamId)) {
            return TeamsInfo.getTeamMembers(turnContext, teamId);
        }
        String conversationId = turnContext.getActivity().getConversation() != null ? turnContext.getActivity().getConversation().getId() : null;
        return TeamsInfo.getMembers(TeamsInfo.getConnectorClient(turnContext), conversationId);
    }

    public static CompletableFuture<TeamsChannelAccount> getMember(TurnContext turnContext, String userId) {
        String teamId = turnContext.getActivity().teamsGetTeamId();
        if (!StringUtils.isEmpty((CharSequence)teamId)) {
            return TeamsInfo.getTeamMember(turnContext, userId, teamId);
        }
        String conversationId = turnContext.getActivity().getConversation() != null ? turnContext.getActivity().getConversation().getId() : null;
        return TeamsInfo.getMember(TeamsInfo.getConnectorClient(turnContext), userId, conversationId);
    }

    public static CompletableFuture<TeamsPagedMembersResult> getPagedTeamMembers(TurnContext turnContext, String teamId, String continuationToken) {
        String effectiveTeamId;
        String string = effectiveTeamId = teamId != null ? teamId : turnContext.getActivity().teamsGetTeamId();
        if (effectiveTeamId == null) {
            return TeamsInfo.illegalArgument("This method is only valid within the scope of MS Teams Team.");
        }
        return TeamsInfo.getPagedMembers(TeamsInfo.getConnectorClient(turnContext), effectiveTeamId, continuationToken);
    }

    public static CompletableFuture<TeamsPagedMembersResult> getPagedMembers(TurnContext turnContext, String continuationToken) {
        String teamId = turnContext.getActivity().teamsGetTeamId();
        if (!StringUtils.isEmpty((CharSequence)teamId)) {
            return TeamsInfo.getPagedTeamMembers(turnContext, teamId, continuationToken);
        }
        String conversationId = turnContext.getActivity().getConversation() != null ? turnContext.getActivity().getConversation().getId() : null;
        return TeamsInfo.getPagedMembers(TeamsInfo.getConnectorClient(turnContext), conversationId, continuationToken);
    }

    public static CompletableFuture<TeamsMeetingParticipant> getMeetingParticipant(TurnContext turnContext) {
        return TeamsInfo.getMeetingParticipant(turnContext, null, null, null);
    }

    public static CompletableFuture<TeamsMeetingParticipant> getMeetingParticipant(TurnContext turnContext, String meetingId, String participantId, String tenantId) {
        if (StringUtils.isEmpty((CharSequence)meetingId)) {
            String string = meetingId = turnContext.getActivity().teamsGetMeetingInfo() != null ? turnContext.getActivity().teamsGetMeetingInfo().getId() : null;
        }
        if (StringUtils.isEmpty((CharSequence)meetingId)) {
            return TeamsInfo.illegalArgument("TeamsInfo.getMeetingParticipant: method requires a meetingId");
        }
        if (StringUtils.isEmpty((CharSequence)participantId)) {
            String string = participantId = turnContext.getActivity().getFrom() != null ? turnContext.getActivity().getFrom().getAadObjectId() : null;
        }
        if (StringUtils.isEmpty((CharSequence)participantId)) {
            return TeamsInfo.illegalArgument("TeamsInfo.getMeetingParticipant: method requires a participantId");
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            String string = tenantId = turnContext.getActivity().teamsGetChannelData() != null ? turnContext.getActivity().teamsGetChannelData().getTenant().getId() : null;
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            return TeamsInfo.illegalArgument("TeamsInfo.getMeetingParticipant: method requires a tenantId");
        }
        return TeamsInfo.getTeamsConnectorClient(turnContext).getTeams().fetchParticipant(meetingId, participantId, tenantId);
    }

    public static CompletableFuture<MeetingInfo> getMeetingInfo(TurnContext turnContext) {
        return TeamsInfo.getMeetingInfo(turnContext, null);
    }

    public static CompletableFuture<MeetingInfo> getMeetingInfo(TurnContext turnContext, String meetingId) {
        if (StringUtils.isEmpty((CharSequence)meetingId) && turnContext.getActivity().teamsGetMeetingInfo() != null) {
            meetingId = turnContext.getActivity().teamsGetMeetingInfo().getId();
        }
        if (StringUtils.isEmpty((CharSequence)meetingId)) {
            return TeamsInfo.illegalArgument("TeamsInfo.getMeetingInfo: method requires a meetingId");
        }
        return TeamsInfo.getTeamsConnectorClient(turnContext).getTeams().fetchMeetingInfo(meetingId);
    }

    private static CompletableFuture<List<TeamsChannelAccount>> getMembers(ConnectorClient connectorClient, String conversationId) {
        if (StringUtils.isEmpty((CharSequence)conversationId)) {
            return TeamsInfo.illegalArgument("The getMembers operation needs a valid conversation Id.");
        }
        return connectorClient.getConversations().getConversationMembers(conversationId).thenApply(teamMembers -> {
            List members = teamMembers.stream().map(channelAccount -> (TeamsChannelAccount)Serialization.convert((Object)channelAccount, TeamsChannelAccount.class)).collect(Collectors.toCollection(ArrayList::new));
            members.removeIf(Objects::isNull);
            return members;
        });
    }

    private static CompletableFuture<TeamsChannelAccount> getMember(ConnectorClient connectorClient, String userId, String conversationId) {
        if (StringUtils.isEmpty((CharSequence)conversationId) || StringUtils.isEmpty((CharSequence)userId)) {
            return TeamsInfo.illegalArgument("The getMember operation needs a valid userId and conversationId.");
        }
        return connectorClient.getConversations().getConversationMember(userId, conversationId).thenApply(teamMember -> (TeamsChannelAccount)Serialization.convert((Object)teamMember, TeamsChannelAccount.class));
    }

    private static CompletableFuture<TeamsPagedMembersResult> getPagedMembers(ConnectorClient connectorClient, String conversationId, String continuationToken) {
        if (StringUtils.isEmpty((CharSequence)conversationId)) {
            return TeamsInfo.illegalArgument("The getPagedMembers operation needs a valid conversation Id.");
        }
        CompletableFuture pagedResult = StringUtils.isEmpty((CharSequence)continuationToken) ? connectorClient.getConversations().getConversationPagedMembers(conversationId) : connectorClient.getConversations().getConversationPagedMembers(conversationId, continuationToken);
        return pagedResult.thenApply(TeamsPagedMembersResult::new);
    }

    private static ConnectorClient getConnectorClient(TurnContext turnContext) {
        ConnectorClient client = (ConnectorClient)turnContext.getTurnState().get("ConnectorClient");
        if (client == null) {
            throw new IllegalStateException("This method requires a connector client.");
        }
        return client;
    }

    private static TeamsConnectorClient getTeamsConnectorClient(TurnContext turnContext) {
        TeamsConnectorClient teamsClient = (TeamsConnectorClient)turnContext.getTurnState().get("TeamsConnectorClient");
        if (teamsClient != null) {
            return teamsClient;
        }
        ConnectorClient client = TeamsInfo.getConnectorClient(turnContext);
        return new RestTeamsConnectorClient(client.baseUrl(), client.credentials());
    }

    public static CompletableFuture<Pair<ConversationReference, String>> sendMessageToTeamsChannel(TurnContext turnContext, Activity activity, String teamsChannelId, MicrosoftAppCredentials credentials) {
        if (turnContext == null) {
            return TeamsInfo.illegalArgument("turnContext is required");
        }
        if (turnContext.getActivity() == null) {
            return TeamsInfo.illegalArgument("turnContext.Activity is required");
        }
        if (StringUtils.isEmpty((CharSequence)teamsChannelId)) {
            return TeamsInfo.illegalArgument("teamsChannelId is required");
        }
        if (credentials == null) {
            return TeamsInfo.illegalArgument("credentials is required");
        }
        AtomicReference conversationReference = new AtomicReference();
        AtomicReference newActivityId = new AtomicReference();
        String serviceUrl = turnContext.getActivity().getServiceUrl();
        TeamsChannelData teamsChannelData = new TeamsChannelData();
        teamsChannelData.setChannel(new ChannelInfo(teamsChannelId));
        ConversationParameters conversationParameters = new ConversationParameters();
        conversationParameters.setIsGroup(true);
        conversationParameters.setChannelData((Object)teamsChannelData);
        conversationParameters.setActivity(activity);
        return ((BotFrameworkAdapter)turnContext.getAdapter()).createConversation(teamsChannelId, serviceUrl, credentials, conversationParameters, context -> {
            conversationReference.set(context.getActivity().getConversationReference());
            newActivityId.set(context.getActivity().getId());
            return CompletableFuture.completedFuture(null);
        }).thenApply(aVoid -> new Pair((Object)((ConversationReference)conversationReference.get()), (Object)((String)newActivityId.get())));
    }

    private static <T> CompletableFuture<T> illegalArgument(String message) {
        CompletableFuture detailResult = new CompletableFuture();
        detailResult.completeExceptionally(new IllegalArgumentException(message));
        return detailResult;
    }
}

