/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder.teams;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bot.builder.ActivityHandler;
import com.microsoft.bot.builder.InvokeResponse;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.builder.teams.TeamsInfo;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.rest.ErrorResponseException;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.Error;
import com.microsoft.bot.schema.ErrorResponse;
import com.microsoft.bot.schema.ResultPair;
import com.microsoft.bot.schema.Serialization;
import com.microsoft.bot.schema.teams.AppBasedLinkQuery;
import com.microsoft.bot.schema.teams.ChannelInfo;
import com.microsoft.bot.schema.teams.FileConsentCardResponse;
import com.microsoft.bot.schema.teams.MeetingEndEventDetails;
import com.microsoft.bot.schema.teams.MeetingStartEventDetails;
import com.microsoft.bot.schema.teams.MessagingExtensionAction;
import com.microsoft.bot.schema.teams.MessagingExtensionActionResponse;
import com.microsoft.bot.schema.teams.MessagingExtensionQuery;
import com.microsoft.bot.schema.teams.MessagingExtensionResponse;
import com.microsoft.bot.schema.teams.O365ConnectorCardActionQuery;
import com.microsoft.bot.schema.teams.TabRequest;
import com.microsoft.bot.schema.teams.TabResponse;
import com.microsoft.bot.schema.teams.TabSubmit;
import com.microsoft.bot.schema.teams.TaskModuleRequest;
import com.microsoft.bot.schema.teams.TaskModuleResponse;
import com.microsoft.bot.schema.teams.TeamInfo;
import com.microsoft.bot.schema.teams.TeamsChannelAccount;
import com.microsoft.bot.schema.teams.TeamsChannelData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.StringUtils;

public class TeamsActivityHandler
extends ActivityHandler {
    @Override
    protected CompletableFuture<InvokeResponse> onInvokeActivity(TurnContext turnContext) {
        CompletionStage<Object> result;
        try {
            if (turnContext.getActivity().getName() == null && turnContext.getActivity().isTeamsActivity()) {
                result = this.onTeamsCardActionInvoke(turnContext);
            } else {
                switch (turnContext.getActivity().getName()) {
                    case "fileConsent/invoke": {
                        result = this.onTeamsFileConsent(turnContext, (FileConsentCardResponse)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), FileConsentCardResponse.class));
                        break;
                    }
                    case "actionableMessage/executeAction": {
                        result = this.onTeamsO365ConnectorCardAction(turnContext, (O365ConnectorCardActionQuery)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), O365ConnectorCardActionQuery.class)).thenApply(aVoid -> this.createInvokeResponse(null));
                        break;
                    }
                    case "composeExtension/queryLink": {
                        result = this.onTeamsAppBasedLinkQuery(turnContext, (AppBasedLinkQuery)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), AppBasedLinkQuery.class)).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "composeExtension/query": {
                        result = this.onTeamsMessagingExtensionQuery(turnContext, (MessagingExtensionQuery)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), MessagingExtensionQuery.class)).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "composeExtension/selectItem": {
                        result = this.onTeamsMessagingExtensionSelectItem(turnContext, turnContext.getActivity().getValue()).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "composeExtension/submitAction": {
                        result = this.onTeamsMessagingExtensionSubmitActionDispatch(turnContext, (MessagingExtensionAction)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), MessagingExtensionAction.class)).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "composeExtension/fetchTask": {
                        result = this.onTeamsMessagingExtensionFetchTask(turnContext, (MessagingExtensionAction)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), MessagingExtensionAction.class)).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "composeExtension/querySettingUrl": {
                        result = this.onTeamsMessagingExtensionConfigurationQuerySettingUrl(turnContext, (MessagingExtensionQuery)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), MessagingExtensionQuery.class)).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "composeExtension/setting": {
                        result = this.onTeamsMessagingExtensionConfigurationSetting(turnContext, turnContext.getActivity().getValue()).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "composeExtension/onCardButtonClicked": {
                        result = this.onTeamsMessagingExtensionCardButtonClicked(turnContext, turnContext.getActivity().getValue()).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "task/fetch": {
                        result = this.onTeamsTaskModuleFetch(turnContext, (TaskModuleRequest)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), TaskModuleRequest.class)).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "task/submit": {
                        result = this.onTeamsTaskModuleSubmit(turnContext, (TaskModuleRequest)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), TaskModuleRequest.class)).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "tab/fetch": {
                        result = this.onTeamsTabFetch(turnContext, (TabRequest)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), TabRequest.class)).thenApply(this::createInvokeResponse);
                        break;
                    }
                    case "tab/submit": {
                        result = this.onTeamsTabSubmit(turnContext, (TabSubmit)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), TabSubmit.class)).thenApply(this::createInvokeResponse);
                        break;
                    }
                    default: {
                        result = super.onInvokeActivity(turnContext);
                    }
                }
            }
        }
        catch (Throwable t) {
            result = new CompletableFuture();
            result.completeExceptionally(t);
        }
        return result.exceptionally(e -> {
            if (e instanceof CompletionException && e.getCause() instanceof ActivityHandler.InvokeResponseException) {
                return ((ActivityHandler.InvokeResponseException)e.getCause()).createInvokeResponse();
            }
            if (e instanceof ActivityHandler.InvokeResponseException) {
                return ((ActivityHandler.InvokeResponseException)e).createInvokeResponse();
            }
            return new InvokeResponse(500, e.getLocalizedMessage());
        });
    }

    protected CompletableFuture<InvokeResponse> onTeamsCardActionInvoke(TurnContext turnContext) {
        return this.notImplemented();
    }

    @Override
    protected CompletableFuture<Void> onSignInInvoke(TurnContext turnContext) {
        return this.onTeamsSigninVerifyState(turnContext);
    }

    protected CompletableFuture<Void> onTeamsSigninVerifyState(TurnContext turnContext) {
        return this.notImplemented();
    }

    protected CompletableFuture<InvokeResponse> onTeamsFileConsent(TurnContext turnContext, FileConsentCardResponse fileConsentCardResponse) {
        switch (fileConsentCardResponse.getAction()) {
            case "accept": {
                return this.onTeamsFileConsentAccept(turnContext, fileConsentCardResponse).thenApply(aVoid -> this.createInvokeResponse(null));
            }
            case "decline": {
                return this.onTeamsFileConsentDecline(turnContext, fileConsentCardResponse).thenApply(aVoid -> this.createInvokeResponse(null));
            }
        }
        CompletableFuture<InvokeResponse> result = new CompletableFuture<InvokeResponse>();
        result.completeExceptionally(new ActivityHandler.InvokeResponseException(400, fileConsentCardResponse.getAction() + " is not a supported Action."));
        return result;
    }

    protected CompletableFuture<Void> onTeamsFileConsentAccept(TurnContext turnContext, FileConsentCardResponse fileConsentCardResponse) {
        return this.notImplemented();
    }

    protected CompletableFuture<Void> onTeamsFileConsentDecline(TurnContext turnContext, FileConsentCardResponse fileConsentCardResponse) {
        return this.notImplemented();
    }

    protected CompletableFuture<MessagingExtensionResponse> onTeamsMessagingExtensionQuery(TurnContext turnContext, MessagingExtensionQuery query) {
        return this.notImplemented();
    }

    protected CompletableFuture<Void> onTeamsO365ConnectorCardAction(TurnContext turnContext, O365ConnectorCardActionQuery query) {
        return this.notImplemented();
    }

    protected CompletableFuture<MessagingExtensionResponse> onTeamsAppBasedLinkQuery(TurnContext turnContext, AppBasedLinkQuery query) {
        return this.notImplemented();
    }

    protected CompletableFuture<MessagingExtensionResponse> onTeamsMessagingExtensionSelectItem(TurnContext turnContext, Object query) {
        return this.notImplemented();
    }

    protected CompletableFuture<MessagingExtensionActionResponse> onTeamsMessagingExtensionFetchTask(TurnContext turnContext, MessagingExtensionAction action) {
        return this.notImplemented();
    }

    protected CompletableFuture<MessagingExtensionActionResponse> onTeamsMessagingExtensionSubmitActionDispatch(TurnContext turnContext, MessagingExtensionAction action) {
        if (!StringUtils.isEmpty((CharSequence)action.getBotMessagePreviewAction())) {
            switch (action.getBotMessagePreviewAction()) {
                case "edit": {
                    return this.onTeamsMessagingExtensionBotMessagePreviewEdit(turnContext, action);
                }
                case "send": {
                    return this.onTeamsMessagingExtensionBotMessagePreviewSend(turnContext, action);
                }
            }
            CompletableFuture<MessagingExtensionActionResponse> result = new CompletableFuture<MessagingExtensionActionResponse>();
            result.completeExceptionally(new ActivityHandler.InvokeResponseException(400, action.getBotMessagePreviewAction() + " is not a support BotMessagePreviewAction"));
            return result;
        }
        return this.onTeamsMessagingExtensionSubmitAction(turnContext, action);
    }

    protected CompletableFuture<MessagingExtensionActionResponse> onTeamsMessagingExtensionSubmitAction(TurnContext turnContext, MessagingExtensionAction action) {
        return this.notImplemented();
    }

    protected CompletableFuture<MessagingExtensionActionResponse> onTeamsMessagingExtensionBotMessagePreviewEdit(TurnContext turnContext, MessagingExtensionAction action) {
        return this.notImplemented();
    }

    protected CompletableFuture<MessagingExtensionActionResponse> onTeamsMessagingExtensionBotMessagePreviewSend(TurnContext turnContext, MessagingExtensionAction action) {
        return this.notImplemented();
    }

    protected CompletableFuture<MessagingExtensionResponse> onTeamsMessagingExtensionConfigurationQuerySettingUrl(TurnContext turnContext, MessagingExtensionQuery query) {
        return this.notImplemented();
    }

    protected CompletableFuture<Void> onTeamsMessagingExtensionConfigurationSetting(TurnContext turnContext, Object settings) {
        return this.notImplemented();
    }

    protected CompletableFuture<TaskModuleResponse> onTeamsTaskModuleFetch(TurnContext turnContext, TaskModuleRequest taskModuleRequest) {
        return this.notImplemented();
    }

    protected CompletableFuture<Void> onTeamsMessagingExtensionCardButtonClicked(TurnContext turnContext, Object cardData) {
        return this.notImplemented();
    }

    protected CompletableFuture<TaskModuleResponse> onTeamsTaskModuleSubmit(TurnContext turnContext, TaskModuleRequest taskModuleRequest) {
        return this.notImplemented();
    }

    @Override
    protected CompletableFuture<Void> onConversationUpdateActivity(TurnContext turnContext) {
        if (turnContext.getActivity().isTeamsActivity()) {
            ResultPair channelData = turnContext.getActivity().tryGetChannelData(TeamsChannelData.class);
            if (turnContext.getActivity().getMembersAdded() != null) {
                return this.onTeamsMembersAddedDispatch(turnContext.getActivity().getMembersAdded(), channelData.result() != false ? ((TeamsChannelData)channelData.value()).getTeam() : null, turnContext);
            }
            if (turnContext.getActivity().getMembersRemoved() != null) {
                return this.onTeamsMembersRemovedDispatch(turnContext.getActivity().getMembersRemoved(), channelData.result() != false ? ((TeamsChannelData)channelData.value()).getTeam() : null, turnContext);
            }
            if (channelData.result().booleanValue()) {
                switch (((TeamsChannelData)channelData.value()).getEventType()) {
                    case "channelCreated": {
                        return this.onTeamsChannelCreated(((TeamsChannelData)channelData.value()).getChannel(), ((TeamsChannelData)channelData.value()).getTeam(), turnContext);
                    }
                    case "channelDeleted": {
                        return this.onTeamsChannelDeleted(((TeamsChannelData)channelData.value()).getChannel(), ((TeamsChannelData)channelData.value()).getTeam(), turnContext);
                    }
                    case "channelRenamed": {
                        return this.onTeamsChannelRenamed(((TeamsChannelData)channelData.value()).getChannel(), ((TeamsChannelData)channelData.value()).getTeam(), turnContext);
                    }
                    case "channelRestored": {
                        return this.onTeamsChannelRestored(((TeamsChannelData)channelData.value()).getChannel(), ((TeamsChannelData)channelData.value()).getTeam(), turnContext);
                    }
                    case "teamArchived": {
                        return this.onTeamsTeamArchived(((TeamsChannelData)channelData.value()).getChannel(), ((TeamsChannelData)channelData.value()).getTeam(), turnContext);
                    }
                    case "teamDeleted": {
                        return this.onTeamsTeamDeleted(((TeamsChannelData)channelData.value()).getChannel(), ((TeamsChannelData)channelData.value()).getTeam(), turnContext);
                    }
                    case "teamHardDeleted": {
                        return this.onTeamsTeamHardDeleted(((TeamsChannelData)channelData.value()).getChannel(), ((TeamsChannelData)channelData.value()).getTeam(), turnContext);
                    }
                    case "teamRenamed": {
                        return this.onTeamsTeamRenamed(((TeamsChannelData)channelData.value()).getChannel(), ((TeamsChannelData)channelData.value()).getTeam(), turnContext);
                    }
                    case "teamRestored": {
                        return this.onTeamsTeamRestored(((TeamsChannelData)channelData.value()).getChannel(), ((TeamsChannelData)channelData.value()).getTeam(), turnContext);
                    }
                    case "teamUnarchived": {
                        return this.onTeamsTeamUnarchived(((TeamsChannelData)channelData.value()).getChannel(), ((TeamsChannelData)channelData.value()).getTeam(), turnContext);
                    }
                }
                return super.onConversationUpdateActivity(turnContext);
            }
        }
        return super.onConversationUpdateActivity(turnContext);
    }

    protected CompletableFuture<Void> onTeamsMembersAddedDispatch(List<ChannelAccount> membersAdded, TeamInfo teamInfo, TurnContext turnContext) {
        ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();
        mapper.findAndRegisterModules();
        ArrayList<TeamsChannelAccount> teamsMembersAdded = new ArrayList<TeamsChannelAccount>();
        for (ChannelAccount memberAdded : membersAdded) {
            boolean isBot;
            boolean bl = isBot = turnContext.getActivity().getRecipient() != null && StringUtils.equals((CharSequence)memberAdded.getId(), (CharSequence)turnContext.getActivity().getRecipient().getId());
            if (!memberAdded.getProperties().isEmpty() || isBot) {
                try {
                    JsonNode node = mapper.valueToTree((Object)memberAdded);
                    teamsMembersAdded.add((TeamsChannelAccount)mapper.treeToValue((TreeNode)node, TeamsChannelAccount.class));
                    continue;
                }
                catch (JsonProcessingException jpe) {
                    return this.withException(jpe);
                }
            }
            TeamsChannelAccount teamsChannelAccount = null;
            try {
                teamsChannelAccount = TeamsInfo.getMember(turnContext, memberAdded.getId()).join();
            }
            catch (CompletionException ex) {
                Throwable causeException = ex.getCause();
                if (causeException instanceof ErrorResponseException) {
                    Error error;
                    ErrorResponse response = ((ErrorResponseException)causeException).body();
                    if (response != null && (error = response.getError()) != null && !error.getCode().equals("ConversationNotFound")) {
                        throw ex;
                    }
                }
                throw ex;
            }
            if (teamsChannelAccount == null) {
                teamsChannelAccount = new TeamsChannelAccount();
                teamsChannelAccount.setId(memberAdded.getId());
                teamsChannelAccount.setName(memberAdded.getName());
                teamsChannelAccount.setAadObjectId(memberAdded.getAadObjectId());
                teamsChannelAccount.setRole(memberAdded.getRole());
            }
            teamsMembersAdded.add(teamsChannelAccount);
        }
        return this.onTeamsMembersAdded(teamsMembersAdded, teamInfo, turnContext);
    }

    protected CompletableFuture<Void> onTeamsMembersRemovedDispatch(List<ChannelAccount> membersRemoved, TeamInfo teamInfo, TurnContext turnContext) {
        ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();
        mapper.findAndRegisterModules();
        ArrayList<TeamsChannelAccount> teamsMembersRemoved = new ArrayList<TeamsChannelAccount>();
        for (ChannelAccount memberRemoved : membersRemoved) {
            try {
                JsonNode node = mapper.valueToTree((Object)memberRemoved);
                teamsMembersRemoved.add((TeamsChannelAccount)mapper.treeToValue((TreeNode)node, TeamsChannelAccount.class));
            }
            catch (JsonProcessingException jpe) {
                return this.withException(jpe);
            }
        }
        return this.onTeamsMembersRemoved(teamsMembersRemoved, teamInfo, turnContext);
    }

    protected CompletableFuture<Void> onTeamsMembersAdded(List<TeamsChannelAccount> membersAdded, TeamInfo teamInfo, TurnContext turnContext) {
        return this.onMembersAdded(new ArrayList<TeamsChannelAccount>(membersAdded), turnContext);
    }

    protected CompletableFuture<Void> onTeamsMembersRemoved(List<TeamsChannelAccount> membersRemoved, TeamInfo teamInfo, TurnContext turnContext) {
        return this.onMembersRemoved(new ArrayList<TeamsChannelAccount>(membersRemoved), turnContext);
    }

    protected CompletableFuture<Void> onTeamsChannelCreated(ChannelInfo channelInfo, TeamInfo teamInfo, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTeamsChannelDeleted(ChannelInfo channelInfo, TeamInfo teamInfo, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTeamsChannelRenamed(ChannelInfo channelInfo, TeamInfo teamInfo, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTeamsChannelRestored(ChannelInfo channelInfo, TeamInfo teamInfo, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTeamsTeamArchived(ChannelInfo channelInfo, TeamInfo teamInfo, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTeamsTeamDeleted(ChannelInfo channelInfo, TeamInfo teamInfo, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTeamsTeamHardDeleted(ChannelInfo channelInfo, TeamInfo teamInfo, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTeamsTeamRenamed(ChannelInfo channelInfo, TeamInfo teamInfo, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTeamsTeamRestored(ChannelInfo channelInfo, TeamInfo teamInfo, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTeamsTeamUnarchived(ChannelInfo channelInfo, TeamInfo teamInfo, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<TabResponse> onTeamsTabFetch(TurnContext turnContext, TabRequest tabRequest) {
        return this.withException(new ActivityHandler.InvokeResponseException(501));
    }

    protected CompletableFuture<TabResponse> onTeamsTabSubmit(TurnContext turnContext, TabSubmit tabSubmit) {
        return this.withException(new ActivityHandler.InvokeResponseException(501));
    }

    @Override
    protected CompletableFuture<Void> onEventActivity(TurnContext turnContext) {
        if (StringUtils.equals((CharSequence)turnContext.getActivity().getChannelId(), (CharSequence)"msteams")) {
            try {
                switch (turnContext.getActivity().getName()) {
                    case "application/vnd.microsoft.meetingStart": {
                        return this.onTeamsMeetingStart((MeetingStartEventDetails)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), MeetingStartEventDetails.class), turnContext);
                    }
                    case "application/vnd.microsoft.meetingEnd": {
                        return this.onTeamsMeetingEnd((MeetingEndEventDetails)Serialization.safeGetAs((Object)turnContext.getActivity().getValue(), MeetingEndEventDetails.class), turnContext);
                    }
                }
            }
            catch (Throwable t) {
                return Async.completeExceptionally((Throwable)t);
            }
        }
        return super.onEventActivity(turnContext);
    }

    protected CompletableFuture<Void> onTeamsMeetingStart(MeetingStartEventDetails meeting, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onTeamsMeetingEnd(MeetingEndEventDetails meeting, TurnContext turnContext) {
        return CompletableFuture.completedFuture(null);
    }

    protected <T> CompletableFuture<T> notImplemented() {
        return this.notImplemented(null);
    }

    protected <T> CompletableFuture<T> notImplemented(String body) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(new ActivityHandler.InvokeResponseException(501, body));
        return result;
    }

    protected <T> CompletableFuture<T> withException(Throwable t) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(new CompletionException(t));
        return result;
    }
}

