/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder.skills;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.bot.builder.Bot;
import com.microsoft.bot.builder.BotAdapter;
import com.microsoft.bot.builder.BotCallbackHandler;
import com.microsoft.bot.builder.ChannelServiceHandler;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.builder.skills.SkillConversationIdFactoryBase;
import com.microsoft.bot.builder.skills.SkillConversationReference;
import com.microsoft.bot.connector.authentication.AuthenticationConfiguration;
import com.microsoft.bot.connector.authentication.ChannelProvider;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.connector.authentication.JwtTokenValidation;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ConversationReference;
import com.microsoft.bot.schema.ResourceResponse;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillHandler
extends ChannelServiceHandler {
    public static final String SKILL_CONVERSATION_REFERENCE_KEY = "com.microsoft.bot.builder.skills.SkillConversationReference";
    private final BotAdapter adapter;
    private final Bot bot;
    private final SkillConversationIdFactoryBase conversationIdFactory;
    private Logger logger = LoggerFactory.getLogger(SkillHandler.class);

    public SkillHandler(BotAdapter adapter, Bot bot, SkillConversationIdFactoryBase conversationIdFactory, CredentialProvider credentialProvider, AuthenticationConfiguration authConfig, ChannelProvider channelProvider) {
        super(credentialProvider, authConfig, channelProvider);
        if (adapter == null) {
            throw new IllegalArgumentException("adapter cannot be null");
        }
        if (bot == null) {
            throw new IllegalArgumentException("bot cannot be null");
        }
        if (conversationIdFactory == null) {
            throw new IllegalArgumentException("conversationIdFactory cannot be null");
        }
        this.adapter = adapter;
        this.bot = bot;
        this.conversationIdFactory = conversationIdFactory;
    }

    @Override
    protected CompletableFuture<ResourceResponse> onSendToConversation(ClaimsIdentity claimsIdentity, String conversationId, Activity activity) {
        return this.processActivity(claimsIdentity, conversationId, null, activity);
    }

    @Override
    protected CompletableFuture<ResourceResponse> onReplyToActivity(ClaimsIdentity claimsIdentity, String conversationId, String activityId, Activity activity) {
        return this.processActivity(claimsIdentity, conversationId, activityId, activity);
    }

    @Override
    protected CompletableFuture<Void> onDeleteActivity(ClaimsIdentity claimsIdentity, String conversationId, String activityId) {
        SkillConversationReference skillConversationReference = this.getSkillConversationReference(conversationId).join();
        BotCallbackHandler callback = turnContext -> {
            turnContext.getTurnState().add(SKILL_CONVERSATION_REFERENCE_KEY, skillConversationReference);
            return turnContext.deleteActivity(activityId);
        };
        return this.adapter.continueConversation(claimsIdentity, skillConversationReference.getConversationReference(), skillConversationReference.getOAuthScope(), callback);
    }

    @Override
    protected CompletableFuture<ResourceResponse> onUpdateActivity(ClaimsIdentity claimsIdentity, String conversationId, String activityId, Activity activity) {
        SkillConversationReference skillConversationReference = this.getSkillConversationReference(conversationId).join();
        AtomicReference resourceResponse = new AtomicReference();
        BotCallbackHandler callback = turnContext -> {
            turnContext.getTurnState().add(SKILL_CONVERSATION_REFERENCE_KEY, skillConversationReference);
            activity.applyConversationReference(skillConversationReference.getConversationReference());
            turnContext.getActivity().setId(activityId);
            String callerId = String.format("%s%s", "urn:botframework:aadappid:", JwtTokenValidation.getAppIdFromClaims((Map)claimsIdentity.claims()));
            turnContext.getActivity().setCallerId(callerId);
            resourceResponse.set(turnContext.updateActivity(activity).join());
            return CompletableFuture.completedFuture(null);
        };
        this.adapter.continueConversation(claimsIdentity, skillConversationReference.getConversationReference(), skillConversationReference.getOAuthScope(), callback);
        if (resourceResponse.get() != null) {
            return CompletableFuture.completedFuture((ResourceResponse)resourceResponse.get());
        }
        return CompletableFuture.completedFuture(new ResourceResponse(UUID.randomUUID().toString()));
    }

    private static void applyEoCToTurnContextActivity(TurnContext turnContext, Activity endOfConversationActivity) {
        turnContext.getActivity().setType(endOfConversationActivity.getType());
        turnContext.getActivity().setText(endOfConversationActivity.getText());
        turnContext.getActivity().setCode(endOfConversationActivity.getCode());
        turnContext.getActivity().setReplyToId(endOfConversationActivity.getReplyToId());
        turnContext.getActivity().setValue(endOfConversationActivity.getValue());
        turnContext.getActivity().setEntities(endOfConversationActivity.getEntities());
        turnContext.getActivity().setLocale(endOfConversationActivity.getLocale());
        turnContext.getActivity().setLocalTimestamp(endOfConversationActivity.getLocalTimestamp());
        turnContext.getActivity().setTimestamp(endOfConversationActivity.getTimestamp());
        turnContext.getActivity().setChannelData(endOfConversationActivity.getChannelData());
        for (Map.Entry entry : endOfConversationActivity.getProperties().entrySet()) {
            turnContext.getActivity().setProperties((String)entry.getKey(), (JsonNode)entry.getValue());
        }
    }

    private static void applyEventToTurnContextActivity(TurnContext turnContext, Activity eventActivity) {
        turnContext.getActivity().setType(eventActivity.getType());
        turnContext.getActivity().setName(eventActivity.getName());
        turnContext.getActivity().setValue(eventActivity.getValue());
        turnContext.getActivity().setRelatesTo(eventActivity.getRelatesTo());
        turnContext.getActivity().setReplyToId(eventActivity.getReplyToId());
        turnContext.getActivity().setValue(eventActivity.getValue());
        turnContext.getActivity().setEntities(eventActivity.getEntities());
        turnContext.getActivity().setLocale(eventActivity.getLocale());
        turnContext.getActivity().setLocalTimestamp(eventActivity.getLocalTimestamp());
        turnContext.getActivity().setTimestamp(eventActivity.getTimestamp());
        turnContext.getActivity().setChannelData(eventActivity.getChannelData());
        for (Map.Entry entry : eventActivity.getProperties().entrySet()) {
            turnContext.getActivity().setProperties((String)entry.getKey(), (JsonNode)entry.getValue());
        }
    }

    private CompletableFuture<SkillConversationReference> getSkillConversationReference(String conversationId) {
        SkillConversationReference skillConversationReference;
        try {
            skillConversationReference = this.conversationIdFactory.getSkillConversationReference(conversationId).join();
        }
        catch (NotImplementedException ex) {
            if (this.logger != null) {
                this.logger.warn("Got NotImplementedException when trying to call GetSkillConversationReference() on the ConversationIdFactory, attempting to use deprecated GetConversationReference() method instead.");
            }
            ConversationReference conversationReference = this.conversationIdFactory.getConversationReference(conversationId).join();
            skillConversationReference = new SkillConversationReference();
            skillConversationReference.setConversationReference(conversationReference);
            if (this.getChannelProvider() != null && this.getChannelProvider().isGovernment()) {
                skillConversationReference.setOAuthScope("https://api.botframework.us/.default");
            }
            skillConversationReference.setOAuthScope("https://api.botframework.com/.default");
        }
        if (skillConversationReference == null) {
            if (this.logger != null) {
                this.logger.warn(String.format("Unable to get skill conversation reference for conversationId %s.", conversationId));
            }
            throw new RuntimeException("Key not found");
        }
        return CompletableFuture.completedFuture(skillConversationReference);
    }

    private CompletableFuture<ResourceResponse> processActivity(ClaimsIdentity claimsIdentity, String conversationId, String replyToActivityId, Activity activity) {
        SkillConversationReference skillConversationReference = this.getSkillConversationReference(conversationId).join();
        AtomicReference resourceResponse = new AtomicReference();
        BotCallbackHandler callback = turnContext -> {
            turnContext.getTurnState().add(SKILL_CONVERSATION_REFERENCE_KEY, skillConversationReference);
            activity.applyConversationReference(skillConversationReference.getConversationReference());
            turnContext.getActivity().setId(replyToActivityId);
            String callerId = String.format("%s%s", "urn:botframework:aadappid:", JwtTokenValidation.getAppIdFromClaims((Map)claimsIdentity.claims()));
            turnContext.getActivity().setCallerId(callerId);
            switch (activity.getType()) {
                case "endOfConversation": {
                    this.conversationIdFactory.deleteConversationReference(conversationId).join();
                    SkillHandler.applyEoCToTurnContextActivity(turnContext, activity);
                    this.bot.onTurn(turnContext).join();
                    break;
                }
                case "event": {
                    SkillHandler.applyEventToTurnContextActivity(turnContext, activity);
                    this.bot.onTurn(turnContext).join();
                    break;
                }
                default: {
                    resourceResponse.set(turnContext.sendActivity(activity).join());
                }
            }
            return CompletableFuture.completedFuture(null);
        };
        this.adapter.continueConversation(claimsIdentity, skillConversationReference.getConversationReference(), skillConversationReference.getOAuthScope(), callback).join();
        if (resourceResponse.get() != null) {
            return CompletableFuture.completedFuture((ResourceResponse)resourceResponse.get());
        }
        return CompletableFuture.completedFuture(new ResourceResponse(UUID.randomUUID().toString()));
    }
}

