/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder.inspection;

import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.NextDelegate;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.builder.inspection.InspectionActivityExtensions;
import com.microsoft.bot.schema.Activity;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public abstract class InterceptionMiddleware
implements Middleware {
    private Logger logger;

    public InterceptionMiddleware(Logger withLogger) {
        this.logger = withLogger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public CompletableFuture<Void> onTurn(TurnContext turnContext, NextDelegate next) {
        return this.invokeInbound(turnContext, InspectionActivityExtensions.traceActivity(turnContext.getActivity(), "ReceivedActivity", "Received Activity")).thenCompose(intercept -> {
            if (intercept.shouldIntercept) {
                turnContext.onSendActivities((sendContext, sendActivities, sendNext) -> {
                    List<Activity> traceActivities = sendActivities.stream().map(a -> InspectionActivityExtensions.traceActivity(a, "SentActivity", "Sent Activity")).collect(Collectors.toList());
                    return this.invokeOutbound(sendContext, traceActivities).thenCompose(arg_0 -> InterceptionMiddleware.lambda$onTurn$1((Supplier)sendNext, arg_0));
                });
                turnContext.onUpdateActivity((updateContext, updateActivity, updateNext) -> {
                    Activity traceActivity = InspectionActivityExtensions.traceActivity(updateActivity, "MessageUpdate", "Message Update");
                    return this.invokeOutbound(turnContext, traceActivity).thenCompose(arg_0 -> InterceptionMiddleware.lambda$onTurn$3((Supplier)updateNext, arg_0));
                });
                turnContext.onDeleteActivity((deleteContext, deleteReference, deleteNext) -> {
                    Activity traceActivity = InspectionActivityExtensions.traceActivity(deleteReference);
                    return this.invokeOutbound(turnContext, traceActivity).thenCompose(arg_0 -> InterceptionMiddleware.lambda$onTurn$5((Supplier)deleteNext, arg_0));
                });
            }
            if (intercept.shouldForwardToApplication) {
                ((CompletableFuture)next.next().exceptionally(exception -> {
                    Activity traceActivity = InspectionActivityExtensions.traceActivity(exception);
                    this.invokeTraceException(turnContext, traceActivity).join();
                    throw new CompletionException((Throwable)exception);
                })).join();
            }
            if (intercept.shouldIntercept) {
                return this.invokeTraceState(turnContext);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    protected abstract CompletableFuture<Intercept> inbound(TurnContext var1, Activity var2);

    protected abstract CompletableFuture<Void> outbound(TurnContext var1, List<Activity> var2);

    protected abstract CompletableFuture<Void> traceState(TurnContext var1);

    private CompletableFuture<Intercept> invokeInbound(TurnContext turnContext, Activity traceActivity) {
        return this.inbound(turnContext, traceActivity).exceptionally(exception -> {
            this.logger.warn("Exception in inbound interception {}", (Object)exception.getMessage());
            return new Intercept(true, false);
        });
    }

    private CompletableFuture<Void> invokeOutbound(TurnContext turnContext, List<Activity> traceActivities) {
        return this.outbound(turnContext, traceActivities).exceptionally(exception -> {
            this.logger.warn("Exception in outbound interception {}", (Object)exception.getMessage());
            return null;
        });
    }

    private CompletableFuture<Void> invokeOutbound(TurnContext turnContext, Activity activity) {
        return this.invokeOutbound(turnContext, Collections.singletonList(activity));
    }

    private CompletableFuture<Void> invokeTraceState(TurnContext turnContext) {
        return this.traceState(turnContext).exceptionally(exception -> {
            this.logger.warn("Exception in state interception {}", (Object)exception.getMessage());
            return null;
        });
    }

    private CompletableFuture<Void> invokeTraceException(TurnContext turnContext, Activity traceActivity) {
        return this.outbound(turnContext, Collections.singletonList(traceActivity)).exceptionally(exception -> {
            this.logger.warn("Exception in exception interception {}", (Object)exception.getMessage());
            return null;
        });
    }

    private static /* synthetic */ CompletionStage lambda$onTurn$5(Supplier deleteNext, Void response) {
        return (CompletionStage)deleteNext.get();
    }

    private static /* synthetic */ CompletionStage lambda$onTurn$3(Supplier updateNext, Void response) {
        return (CompletionStage)updateNext.get();
    }

    private static /* synthetic */ CompletionStage lambda$onTurn$1(Supplier sendNext, Void response) {
        return (CompletionStage)sendNext.get();
    }

    static class Intercept {
        boolean shouldForwardToApplication;
        boolean shouldIntercept;

        Intercept(boolean forward, boolean intercept) {
            this.shouldForwardToApplication = forward;
            this.shouldIntercept = intercept;
        }
    }
}

