/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder.inspection;

import com.microsoft.bot.connector.ConnectorClient;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.bot.connector.rest.RestConnectorClient;
import com.microsoft.bot.restclient.credentials.ServiceClientCredentials;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ConversationReference;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectionSession {
    private ConversationReference conversationReference;
    private Logger logger;
    private ConnectorClient connectorClient;

    public InspectionSession(ConversationReference withConversationReference, MicrosoftAppCredentials withCredentials) {
        this(withConversationReference, withCredentials, null);
    }

    public InspectionSession(ConversationReference withConversationReference, MicrosoftAppCredentials withCredentials, Logger withLogger) {
        this.conversationReference = withConversationReference;
        this.logger = withLogger != null ? withLogger : LoggerFactory.getLogger(InspectionSession.class);
        this.connectorClient = new RestConnectorClient(this.conversationReference.getServiceUrl(), (ServiceClientCredentials)withCredentials);
    }

    public CompletableFuture<Boolean> send(Activity activity) {
        return this.connectorClient.getConversations().sendToConversation(activity.applyConversationReference(this.conversationReference)).handle((result, exception) -> {
            if (exception == null) {
                return true;
            }
            this.logger.warn("Exception '{}' while attempting to call Emulator for inspection, check it is running, and you have correct credentials in the Emulator and the InspectionMiddleware.", (Object)exception.getMessage());
            return false;
        });
    }
}

