/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.Attachment;
import com.microsoft.bot.schema.ConversationAccount;
import com.microsoft.bot.schema.Transcript;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public final class EventFactory {
    private EventFactory() {
    }

    public static Activity createHandoffInitiation(TurnContext turnContext, Object handoffContext) {
        return EventFactory.createHandoffInitiation(turnContext, handoffContext, null);
    }

    public static Activity createHandoffInitiation(TurnContext turnContext, Object handoffContext, Transcript transcript) {
        if (turnContext == null) {
            throw new IllegalArgumentException("turnContext cannot be null.");
        }
        Activity handoffEvent = EventFactory.createHandoffEvent("handoff.initiate", handoffContext, turnContext.getActivity().getConversation());
        handoffEvent.setFrom(turnContext.getActivity().getFrom());
        handoffEvent.setRelatesTo(turnContext.getActivity().getConversationReference());
        handoffEvent.setReplyToId(turnContext.getActivity().getId());
        handoffEvent.setServiceUrl(turnContext.getActivity().getServiceUrl());
        handoffEvent.setChannelId(turnContext.getActivity().getChannelId());
        if (transcript != null) {
            Attachment attachment = new Attachment();
            attachment.setContent((Object)transcript);
            attachment.setContentType("application/json");
            attachment.setName("Transcript");
            handoffEvent.getAttachments().add(attachment);
        }
        return handoffEvent;
    }

    public static Activity createHandoffStatus(ConversationAccount conversation, String state) {
        return EventFactory.createHandoffStatus(conversation, state, null);
    }

    public static Activity createHandoffStatus(ConversationAccount conversation, String state, String message) {
        if (conversation == null) {
            throw new IllegalArgumentException("conversation cannot be null.");
        }
        if (state == null) {
            throw new IllegalArgumentException("state cannot be null.");
        }
        ObjectNode handoffContext = JsonNodeFactory.instance.objectNode();
        handoffContext.set("state", (JsonNode)JsonNodeFactory.instance.textNode(state));
        if (StringUtils.isNotBlank((CharSequence)message)) {
            handoffContext.set("message", (JsonNode)JsonNodeFactory.instance.textNode(message));
        }
        Activity handoffEvent = EventFactory.createHandoffEvent("handoff.status", handoffContext, conversation);
        return handoffEvent;
    }

    private static Activity createHandoffEvent(String name, Object value, ConversationAccount conversation) {
        Activity handoffEvent = Activity.createEventActivity();
        handoffEvent.setName(name);
        handoffEvent.setValue(value);
        handoffEvent.setId(UUID.randomUUID().toString());
        handoffEvent.setTimestamp(OffsetDateTime.now(ZoneId.of("UTC")));
        handoffEvent.setConversation(conversation);
        handoffEvent.setAttachments(new ArrayList());
        handoffEvent.setEntities(new ArrayList());
        return handoffEvent;
    }
}

