/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.bulk;

import java.util.HashMap;
import java.util.Map;

public class CsvHeaders {
    public static final String[] HiddenHeaders = new String[0];
    public static final String[] Headers = new String[]{"Type", "Status", "Id", "Parent Id", "Sub Type", "Campaign", "Ad Group", "Website", "Sync Time", "Client Id", "Modified Time", "Time Zone", "Budget", "Budget Type", "KeywordVariantMatchEnabled", "Start Date", "End Date", "Network Distribution", "Pricing Model", "Ad Rotation", "Search Network", "Search Broad Bid", "Content Network", "Content Bid", "Language", "Title", "Text", "Display Url", "Destination Url", "Business Name", "Phone Number", "Promotion", "Editorial Status", "Editorial Location", "Editorial Term", "Editorial Reason Code", "Editorial Appeal Status", "Device Preference", "Keyword", "Match Type", "Bid", "Param1", "Param2", "Param3", "Target", "Physical Intent", "Target All", "Bid Adjustment", "Radius Target Id", "Name", "OS Names", "Radius", "Unit", "Business Id", "From Hour", "From Minute", "To Hour", "To Minute", "Version", "Sitelink Extension Order", "Sitelink Extension Link Text", "Sitelink Extension Destination Url", "Sitelink Extension Description1", "Sitelink Extension Description2", "Geo Code Status", "Map Icon", "Business Icon", "Address Line 1", "Address Line 2", "Postal Code", "City", "State Or Province Code", "Province Name", "Latitude", "Longitude", "COUNTRY_CODE", "Call Only", "Call Tracking Enabled", "Toll Free", "Alternative Text", "Media Id", "Publisher Countries", "Store Id", "Store Name", "Product Condition 1", "Product Value 1", "Product Condition 2", "Product Value 2", "Product Condition 3", "Product Value 3", "Product Condition 4", "Product Value 4", "Product Condition 5", "Product Value 5", "Product Condition 6", "Product Value 6", "Product Condition 7", "Product Value 7", "Product Condition 8", "Product Value 8", "Spend", "Impressions", "Clicks", "CTR", "Avg CPC", "Avg CPM", "Avg position", "Conversions", "CPA", "Quality Score", "Keyword Relevance", "Landing Page Relevance", "Landing Page User Experience", "App Platform", "App Id", "Tracking Enabled", "Error", "Error Number"};
    private static final Map<String, Integer> columnIndexMap = CsvHeaders.initializeMap();

    public static Map<String, Integer> getMappings() {
        return columnIndexMap;
    }

    public static int GetColumnIndex(String columnName) {
        if (!columnIndexMap.containsKey(columnName)) {
            throw new IllegalArgumentException(String.format("Column name %s is not present in headers.", columnName));
        }
        Integer index = columnIndexMap.get(columnName);
        return index;
    }

    private static Map<String, Integer> initializeMap() {
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        for (int i = 0; i < Headers.length; ++i) {
            mapping.put(Headers[i], new Integer(i));
        }
        return mapping;
    }
}

