/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.utilities;

import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.internal.ResultFuture;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.internal.utilities.HttpFileService;
import com.microsoft.bingads.internal.utilities.UnsuccessfulFileUpload;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Future;
import org.apache.cxf.helpers.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpClientHttpFileService
implements HttpFileService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(String url, File tempZipFile, boolean overwrite) throws IOException, URISyntaxException {
        if (!overwrite && tempZipFile.exists()) {
            throw new IOException(String.format("File %s already exists", tempZipFile));
        }
        DefaultHttpClient client = null;
        try {
            client = new DefaultHttpClient();
            HttpGet httpget = new HttpGet(new URI(url));
            HttpResponse response = client.execute((HttpUriRequest)httpget);
            InputStream content = response.getEntity().getContent();
            FileOutputStream tempFileOutput = null;
            try {
                tempFileOutput = new FileOutputStream(tempZipFile);
                IOUtils.copy((InputStream)content, (OutputStream)tempFileOutput);
            }
            finally {
                if (tempFileOutput != null) {
                    tempFileOutput.close();
                }
            }
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
        }
    }

    @Override
    public void uploadFile(URI uri, File uploadFilePath, Consumer<HttpRequest> addHeaders) throws UnsuccessfulFileUpload {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(uploadFilePath);
            DefaultHttpClient client = null;
            try {
                client = new DefaultHttpClient();
                HttpPost post = new HttpPost(uri);
                addHeaders.accept((HttpRequest)post);
                MultipartEntity e = new MultipartEntity();
                e.addPart("file", (ContentBody)new FileBody(uploadFilePath, "application/octet-stream"));
                post.setEntity((HttpEntity)e);
                HttpResponse response = client.execute((HttpUriRequest)post);
                if (response.getStatusLine().getStatusCode() != 200) {
                    InputStream responseStream = response.getEntity().getContent();
                    String details = IOUtils.toString((InputStream)responseStream);
                    throw new UnsuccessfulFileUpload("Unsuccessful Status Code: " + response.getStatusLine().getStatusCode());
                }
            }
            catch (ClientProtocolException e) {
                throw new UnsuccessfulFileUpload((IOException)((Object)e));
            }
            catch (IOException e) {
                throw new UnsuccessfulFileUpload(e);
            }
            finally {
                if (client != null) {
                    client.getConnectionManager().shutdown();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new UnsuccessfulFileUpload(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new UnsuccessfulFileUpload(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<File> downloadFileAsync(String url, File tempZipFile, AsyncCallback<File> callback) {
        ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        DefaultHttpClient client = null;
        try {
            client = new DefaultHttpClient();
            HttpGet httpget = new HttpGet(new URI(url));
            HttpResponse response = client.execute((HttpUriRequest)httpget);
            InputStream content = response.getEntity().getContent();
            FileOutputStream tempFileOutput = null;
            try {
                tempFileOutput = new FileOutputStream(tempZipFile);
                IOUtils.copy((InputStream)content, (OutputStream)tempFileOutput);
                resultFuture.setResult(tempZipFile);
            }
            finally {
                if (tempFileOutput != null) {
                    tempFileOutput.close();
                }
            }
        }
        catch (URISyntaxException ex) {
            resultFuture.setException(ex);
        }
        catch (IOException ex) {
            resultFuture.setException(ex);
        }
        catch (IllegalStateException ex) {
            resultFuture.setException(ex);
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
        }
        return resultFuture;
    }
}

