/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkAccount;
import com.microsoft.bingads.bulk.entities.BulkAdGroup;
import com.microsoft.bingads.bulk.entities.BulkAdGroupAgeTargetBid;
import com.microsoft.bingads.bulk.entities.BulkAdGroupDayTimeTargetBid;
import com.microsoft.bingads.bulk.entities.BulkAdGroupDeviceOsTargetBid;
import com.microsoft.bingads.bulk.entities.BulkAdGroupGenderTargetBid;
import com.microsoft.bingads.bulk.entities.BulkAdGroupImageAdExtension;
import com.microsoft.bingads.bulk.entities.BulkAdGroupLocationTargetBid;
import com.microsoft.bingads.bulk.entities.BulkAdGroupNegativeKeyword;
import com.microsoft.bingads.bulk.entities.BulkAdGroupNegativeLocationTargetBid;
import com.microsoft.bingads.bulk.entities.BulkAdGroupNegativeSite;
import com.microsoft.bingads.bulk.entities.BulkAdGroupProductTarget;
import com.microsoft.bingads.bulk.entities.BulkAdGroupRadiusTargetBid;
import com.microsoft.bingads.bulk.entities.BulkAdGroupSiteLinkAdExtension;
import com.microsoft.bingads.bulk.entities.BulkAdGroupTargetIdentifier;
import com.microsoft.bingads.bulk.entities.BulkCallAdExtension;
import com.microsoft.bingads.bulk.entities.BulkCampaign;
import com.microsoft.bingads.bulk.entities.BulkCampaignAgeTargetBid;
import com.microsoft.bingads.bulk.entities.BulkCampaignCallAdExtension;
import com.microsoft.bingads.bulk.entities.BulkCampaignDayTimeTargetBid;
import com.microsoft.bingads.bulk.entities.BulkCampaignDeviceOsTargetBid;
import com.microsoft.bingads.bulk.entities.BulkCampaignGenderTargetBid;
import com.microsoft.bingads.bulk.entities.BulkCampaignImageAdExtension;
import com.microsoft.bingads.bulk.entities.BulkCampaignLocationAdExtension;
import com.microsoft.bingads.bulk.entities.BulkCampaignLocationTargetBid;
import com.microsoft.bingads.bulk.entities.BulkCampaignNegativeKeyword;
import com.microsoft.bingads.bulk.entities.BulkCampaignNegativeKeywordList;
import com.microsoft.bingads.bulk.entities.BulkCampaignNegativeLocationTargetBid;
import com.microsoft.bingads.bulk.entities.BulkCampaignNegativeSite;
import com.microsoft.bingads.bulk.entities.BulkCampaignProductAdExtension;
import com.microsoft.bingads.bulk.entities.BulkCampaignRadiusTargetBid;
import com.microsoft.bingads.bulk.entities.BulkCampaignSiteLinkAdExtension;
import com.microsoft.bingads.bulk.entities.BulkCampaignTargetIdentifier;
import com.microsoft.bingads.bulk.entities.BulkError;
import com.microsoft.bingads.bulk.entities.BulkImageAdExtension;
import com.microsoft.bingads.bulk.entities.BulkKeyword;
import com.microsoft.bingads.bulk.entities.BulkKeywordBestPositionBid;
import com.microsoft.bingads.bulk.entities.BulkKeywordFirstPageBid;
import com.microsoft.bingads.bulk.entities.BulkKeywordMainLineBid;
import com.microsoft.bingads.bulk.entities.BulkLocationAdExtension;
import com.microsoft.bingads.bulk.entities.BulkMobileAd;
import com.microsoft.bingads.bulk.entities.BulkNegativeKeywordList;
import com.microsoft.bingads.bulk.entities.BulkProductAd;
import com.microsoft.bingads.bulk.entities.BulkProductConditionCollection;
import com.microsoft.bingads.bulk.entities.BulkSharedNegativeKeyword;
import com.microsoft.bingads.bulk.entities.BulkSiteLink;
import com.microsoft.bingads.bulk.entities.BulkTargetIdentifier;
import com.microsoft.bingads.bulk.entities.BulkTextAd;
import com.microsoft.bingads.bulk.entities.EntityInfo;
import com.microsoft.bingads.bulk.entities.UnknownBulkEntity;
import com.microsoft.bingads.internal.bulk.BulkObject;
import com.microsoft.bingads.internal.bulk.BulkObjectFactory;
import com.microsoft.bingads.internal.bulk.Creator;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.entities.BulkAdGroupNegativeSitesIdentifier;
import com.microsoft.bingads.internal.bulk.entities.BulkCampaignNegativeSitesIdentifier;
import com.microsoft.bingads.internal.bulk.entities.BulkEntityIdentifier;
import com.microsoft.bingads.internal.bulk.entities.BulkProductAdExtensionIdentifier;
import com.microsoft.bingads.internal.bulk.entities.SingleRecordBulkEntity;
import com.microsoft.bingads.internal.bulk.entities.SiteLinkAdExtensionIdentifier;
import com.microsoft.bingads.internal.functionalinterfaces.Supplier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StaticBulkObjectFactory
implements BulkObjectFactory {
    private static final Map<Class<? extends BulkObject>, String> TYPE_REVERSE_MAP;
    private static final Map<Class, Map<Class, String>> TARGET_IDENTIFIER_TYPE_REVERSE_MAP;
    private static final Map<String, EntityInfo> INDIVIDUAL_ENTITY_MAP;
    private static final Map<String, Supplier<BulkObject>> ADDITIONAL_OBJECT_MAP;

    @Override
    public BulkObject createBulkObject(RowValues values) {
        String type = values.get("Type");
        if (type.endsWith("Error")) {
            return new BulkError();
        }
        if (ADDITIONAL_OBJECT_MAP.containsKey(type)) {
            return ADDITIONAL_OBJECT_MAP.get(type).get();
        }
        if (!INDIVIDUAL_ENTITY_MAP.containsKey(type)) {
            return new UnknownBulkEntity();
        }
        EntityInfo info = INDIVIDUAL_ENTITY_MAP.get(type);
        if ("Deleted".equals(values.get("Status")) && info.getDeleteAllColumnName() != null && !info.getDeleteAllColumnName().isEmpty() && (values.get(info.getDeleteAllColumnName()) == null || values.get(info.getDeleteAllColumnName()).isEmpty())) {
            return info.getIdentifierCreator().create();
        }
        return info.getCreator().create();
    }

    @Override
    public String getBulkRowType(BulkObject bulkObject) {
        if (bulkObject instanceof BulkError) {
            BulkError error = (BulkError)bulkObject;
            return this.getBulkRowType(error.getEntity()) + " Error";
        }
        if (bulkObject instanceof BulkTargetIdentifier) {
            BulkTargetIdentifier identifier = (BulkTargetIdentifier)bulkObject;
            return TARGET_IDENTIFIER_TYPE_REVERSE_MAP.get(identifier.getClass()).get(identifier.getTargetBidType());
        }
        return TYPE_REVERSE_MAP.get(bulkObject.getClass());
    }

    static {
        HashMap<String, EntityInfo> m = new HashMap<String, EntityInfo>();
        m.put("Account", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccount();
            }
        }));
        m.put("Campaign", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaign();
            }
        }));
        m.put("Ad Group", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroup();
            }
        }));
        m.put("Mobile Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkMobileAd();
            }
        }));
        m.put("Product Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkProductAd();
            }
        }));
        m.put("Text Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkTextAd();
            }
        }));
        m.put("Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkKeyword();
            }
        }));
        m.put("Sitelink Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkSiteLink();
            }
        }, "Sitelink Extension Order", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new SiteLinkAdExtensionIdentifier();
            }
        }));
        m.put("Campaign Sitelink Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignSiteLinkAdExtension();
            }
        }));
        m.put("AdGroup Sitelink Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupSiteLinkAdExtension();
            }
        }));
        m.put("Product Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkProductConditionCollection();
            }
        }, "Store Id", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkProductAdExtensionIdentifier();
            }
        }));
        m.put("Campaign Product Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignProductAdExtension();
            }
        }));
        m.put("Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkImageAdExtension();
            }
        }));
        m.put("Campaign Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignImageAdExtension();
            }
        }));
        m.put("Ad Group Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupImageAdExtension();
            }
        }));
        m.put("Location Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkLocationAdExtension();
            }
        }));
        m.put("Campaign Location Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignLocationAdExtension();
            }
        }));
        m.put("Call Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCallAdExtension();
            }
        }));
        m.put("Campaign Call Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignCallAdExtension();
            }
        }));
        m.put("Campaign Negative Site", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeSite();
            }
        }, "Website", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkCampaignNegativeSitesIdentifier();
            }
        }));
        m.put("Ad Group Negative Site", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeSite();
            }
        }, "Website", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkAdGroupNegativeSitesIdentifier();
            }
        }));
        m.put("Campaign Age Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignAgeTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkCampaignTargetIdentifier(BulkCampaignAgeTargetBid.class);
            }
        }));
        m.put("Campaign DayTime Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignDayTimeTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkCampaignTargetIdentifier(BulkCampaignDayTimeTargetBid.class);
            }
        }));
        m.put("Campaign DeviceOS Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignDeviceOsTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkCampaignTargetIdentifier(BulkCampaignDeviceOsTargetBid.class);
            }
        }));
        m.put("Campaign Gender Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignGenderTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkCampaignTargetIdentifier(BulkCampaignGenderTargetBid.class);
            }
        }));
        m.put("Campaign Location Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignLocationTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkCampaignTargetIdentifier(BulkCampaignLocationTargetBid.class);
            }
        }));
        m.put("Campaign Negative Location Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeLocationTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkCampaignTargetIdentifier(BulkCampaignNegativeLocationTargetBid.class);
            }
        }));
        m.put("Campaign Radius Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignRadiusTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkCampaignTargetIdentifier(BulkCampaignRadiusTargetBid.class);
            }
        }));
        m.put("Ad Group Age Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupAgeTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkAdGroupTargetIdentifier(BulkAdGroupAgeTargetBid.class);
            }
        }));
        m.put("Ad Group DayTime Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupDayTimeTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkAdGroupTargetIdentifier(BulkAdGroupDayTimeTargetBid.class);
            }
        }));
        m.put("Ad Group DeviceOS Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupDeviceOsTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkAdGroupTargetIdentifier(BulkAdGroupDeviceOsTargetBid.class);
            }
        }));
        m.put("Ad Group Gender Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupGenderTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkAdGroupTargetIdentifier(BulkAdGroupGenderTargetBid.class);
            }
        }));
        m.put("Ad Group Location Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupLocationTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkAdGroupTargetIdentifier(BulkAdGroupLocationTargetBid.class);
            }
        }));
        m.put("Ad Group Negative Location Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeLocationTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkAdGroupTargetIdentifier(BulkAdGroupNegativeLocationTargetBid.class);
            }
        }));
        m.put("Ad Group Radius Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupRadiusTargetBid();
            }
        }, "Target", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkAdGroupTargetIdentifier(BulkAdGroupRadiusTargetBid.class);
            }
        }));
        m.put("Campaign Negative Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeKeyword();
            }
        }));
        m.put("Ad Group Negative Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeKeyword();
            }
        }));
        m.put("Negative Keyword List", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkNegativeKeywordList();
            }
        }));
        m.put("Shared Negative Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkSharedNegativeKeyword();
            }
        }));
        m.put("Campaign Negative Keyword List Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeKeywordList();
            }
        }));
        m.put("Ad Group Product Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupProductTarget();
            }
        }));
        INDIVIDUAL_ENTITY_MAP = Collections.unmodifiableMap(m);
        HashMap<String, Supplier<BulkObject>> addl = new HashMap<String, Supplier<BulkObject>>();
        addl.put("Keyword Best Position Bid", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new BulkKeywordBestPositionBid();
            }
        });
        addl.put("Keyword Main Line Bid", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new BulkKeywordMainLineBid();
            }
        });
        addl.put("Keyword First Page Bid", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new BulkKeywordFirstPageBid();
            }
        });
        ADDITIONAL_OBJECT_MAP = Collections.unmodifiableMap(addl);
        HashMap c = new HashMap();
        HashMap targetIdentifierTypeReverseMap = new HashMap();
        for (Map.Entry<String, EntityInfo> entry : INDIVIDUAL_ENTITY_MAP.entrySet()) {
            c.put(entry.getValue().getCreator().create().getClass(), entry.getKey());
            if (entry.getValue().getIdentifierCreator() == null) continue;
            BulkEntityIdentifier identifier = entry.getValue().getIdentifierCreator().create();
            if (identifier instanceof BulkTargetIdentifier) {
                if (!targetIdentifierTypeReverseMap.containsKey(identifier.getClass())) {
                    targetIdentifierTypeReverseMap.put(identifier.getClass(), new HashMap());
                }
                ((Map)targetIdentifierTypeReverseMap.get(identifier.getClass())).put(((BulkTargetIdentifier)identifier).getTargetBidType(), entry.getKey());
                continue;
            }
            c.put(identifier.getClass(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : ADDITIONAL_OBJECT_MAP.entrySet()) {
            c.put(((BulkObject)((Supplier)entry.getValue()).get()).getClass(), entry.getKey());
        }
        TYPE_REVERSE_MAP = Collections.unmodifiableMap(c);
        TARGET_IDENTIFIER_TYPE_REVERSE_MAP = Collections.unmodifiableMap(targetIdentifierTypeReverseMap);
    }
}

