/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkTargetBid;
import com.microsoft.bingads.bulk.entities.BulkTargetIdentifier;
import com.microsoft.bingads.campaignmanagement.Day;
import com.microsoft.bingads.campaignmanagement.DayTimeTargetBid;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class BulkDayTimeTargetBid
extends BulkTargetBid {
    private DayTimeTargetBid dayTimeTargetBid;
    private static final List<BulkMapping<BulkDayTimeTargetBid>> MAPPINGS;

    BulkDayTimeTargetBid(BulkTargetIdentifier identifier) {
        super(identifier);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setDayTimeTargetBid(new DayTimeTargetBid());
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getDayTimeTargetBid(), "DayTimeTargetBid");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public DayTimeTargetBid getDayTimeTargetBid() {
        return this.dayTimeTargetBid;
    }

    public void setDayTimeTargetBid(DayTimeTargetBid dayTimeTargetBid) {
        this.dayTimeTargetBid = dayTimeTargetBid;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkDayTimeTargetBid, Object>> m = new ArrayList<SimpleBulkMapping<BulkDayTimeTargetBid, Object>>();
        m.add(new SimpleBulkMapping<BulkDayTimeTargetBid, String>("Target", new Function<BulkDayTimeTargetBid, String>(){

            @Override
            public String apply(BulkDayTimeTargetBid c) {
                return c.getDayTimeTargetBid().getDay().value();
            }
        }, new BiConsumer<String, BulkDayTimeTargetBid>(){

            @Override
            public void accept(String v, BulkDayTimeTargetBid c) {
                c.getDayTimeTargetBid().setDay(Day.fromValue(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDayTimeTargetBid, Integer>("From Hour", new Function<BulkDayTimeTargetBid, Integer>(){

            @Override
            public Integer apply(BulkDayTimeTargetBid c) {
                return c.getDayTimeTargetBid().getFromHour();
            }
        }, new BiConsumer<String, BulkDayTimeTargetBid>(){

            @Override
            public void accept(String v, BulkDayTimeTargetBid c) {
                c.getDayTimeTargetBid().setFromHour(Integer.parseInt(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDayTimeTargetBid, Integer>("To Hour", new Function<BulkDayTimeTargetBid, Integer>(){

            @Override
            public Integer apply(BulkDayTimeTargetBid c) {
                return c.getDayTimeTargetBid().getToHour();
            }
        }, new BiConsumer<String, BulkDayTimeTargetBid>(){

            @Override
            public void accept(String v, BulkDayTimeTargetBid c) {
                c.getDayTimeTargetBid().setToHour(Integer.parseInt(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDayTimeTargetBid, String>("From Minute", new Function<BulkDayTimeTargetBid, String>(){

            @Override
            public String apply(BulkDayTimeTargetBid c) {
                return StringExtensions.toMinuteBulkString(c.getDayTimeTargetBid().getFromMinute());
            }
        }, new BiConsumer<String, BulkDayTimeTargetBid>(){

            @Override
            public void accept(String v, BulkDayTimeTargetBid c) {
                c.getDayTimeTargetBid().setFromMinute(StringExtensions.parseMinute(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDayTimeTargetBid, String>("To Minute", new Function<BulkDayTimeTargetBid, String>(){

            @Override
            public String apply(BulkDayTimeTargetBid c) {
                return StringExtensions.toMinuteBulkString(c.getDayTimeTargetBid().getToMinute());
            }
        }, new BiConsumer<String, BulkDayTimeTargetBid>(){

            @Override
            public void accept(String v, BulkDayTimeTargetBid c) {
                c.getDayTimeTargetBid().setToMinute(StringExtensions.parseMinute(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDayTimeTargetBid, Integer>("Bid Adjustment", new Function<BulkDayTimeTargetBid, Integer>(){

            @Override
            public Integer apply(BulkDayTimeTargetBid c) {
                return c.getDayTimeTargetBid().getBidAdjustment();
            }
        }, new BiConsumer<String, BulkDayTimeTargetBid>(){

            @Override
            public void accept(String v, BulkDayTimeTargetBid c) {
                c.getDayTimeTargetBid().setBidAdjustment(Integer.parseInt(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

