/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk;

import com.microsoft.bingads.bulk.BulkEntityIterable;
import com.microsoft.bingads.bulk.DownloadFileType;
import com.microsoft.bingads.bulk.ResultFileType;
import com.microsoft.bingads.internal.bulk.BulkStreamReader;
import com.microsoft.bingads.internal.bulk.SimpleBulkStreamReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class BulkFileReader
implements Closeable {
    private BulkStreamReader bulkStreamReader;
    private String bulkFilePath;
    private ResultFileType fileType;

    public BulkFileReader(File file, ResultFileType resultFileType, DownloadFileType fileFormat) throws IOException {
        this(new SimpleBulkStreamReader(file, fileFormat), resultFileType);
        this.bulkFilePath = file.getCanonicalPath();
    }

    public BulkFileReader(BulkStreamReader reader, ResultFileType fileType) {
        this.bulkStreamReader = reader;
        this.fileType = fileType;
    }

    public BulkEntityIterable getEntities() {
        return new BulkEntityIterable(this.bulkStreamReader, this.isForFullDownload());
    }

    @Override
    public void close() throws IOException {
        this.bulkStreamReader.close();
    }

    boolean isForFullDownload() {
        return this.fileType == ResultFileType.FULL_DOWNLOAD;
    }

    public String getBulkFilePath() {
        return this.bulkFilePath;
    }
}

