/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.OAuthTokens;
import com.microsoft.bingads.internal.LiveComOAuthService;
import com.microsoft.bingads.internal.OAuthAuthorization;
import com.microsoft.bingads.internal.OAuthUrlParameters;
import com.microsoft.bingads.internal.URLExtensions;
import java.net.URL;
import java.util.Map;

public abstract class OAuthImplicitGrant
extends OAuthAuthorization {
    private static final String EXPIRES_IN = "expires_in";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String TOKEN = "token";
    private final String clientId;
    private final URL redirectionUri;

    public OAuthImplicitGrant(String clientId, URL redirectionUri) {
        this.clientId = clientId;
        this.redirectionUri = redirectionUri;
    }

    @Override
    public URL getAuthorizationEndpoint() {
        return LiveComOAuthService.getAuthorizationEndpoint(new OAuthUrlParameters(this.clientId, TOKEN, this.redirectionUri));
    }

    public OAuthTokens extractAccessTokenFromUrl(URL redirectionUri) {
        Map<String, String> fragmentParts = URLExtensions.parseFragment(redirectionUri);
        this.oAuthTokens = new OAuthTokens(fragmentParts.get(ACCESS_TOKEN), Integer.parseInt(fragmentParts.get(EXPIRES_IN)), null);
        return this.oAuthTokens;
    }
}

