/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.PerformanceData;
import com.microsoft.bingads.bulk.entities.QualityScoreData;
import com.microsoft.bingads.campaignmanagement.BudgetLimitType;
import com.microsoft.bingads.campaignmanagement.Campaign;
import com.microsoft.bingads.campaignmanagement.CampaignStatus;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.bulk.entities.SingleRecordBulkEntity;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaign
extends SingleRecordBulkEntity {
    private Long accountId;
    private Campaign campaign;
    private QualityScoreData qualityScoreData;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkCampaign>> MAPPINGS;
    private static BiConsumer<BulkCampaign, RowValues> budgetToCsv;
    private static BiConsumer<RowValues, BulkCampaign> csvToBudget;

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public void setCampaign(Campaign campaign) {
        this.campaign = campaign;
    }

    public QualityScoreData getQualityScoreData() {
        return this.qualityScoreData;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setCampaign(new Campaign());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.qualityScoreData = QualityScoreData.readFromRowValuesOrNull(values);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCampaign(), "Campaign");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            QualityScoreData.writeToRowValuesIfNotNull(this.qualityScoreData, values);
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public static boolean isDailyBudget(BudgetLimitType budgetType) {
        return BudgetLimitType.DAILY_BUDGET_ACCELERATED.equals((Object)budgetType) || BudgetLimitType.DAILY_BUDGET_STANDARD.equals((Object)budgetType);
    }

    static {
        budgetToCsv = new BiConsumer<BulkCampaign, RowValues>(){

            @Override
            public void accept(BulkCampaign c, RowValues values) {
                BudgetLimitType budgetType = c.getCampaign().getBudgetType();
                if (budgetType == null) {
                    return;
                }
                Double budget = BulkCampaign.isDailyBudget(budgetType) ? c.getCampaign().getDailyBudget() : c.getCampaign().getMonthlyBudget();
                if (budget == null) {
                    return;
                }
                values.put("Budget", budget.toString());
            }
        };
        csvToBudget = new BiConsumer<RowValues, BulkCampaign>(){

            @Override
            public void accept(RowValues values, BulkCampaign c) {
                String budgetTypeRowValue = values.get("Budget Type");
                BudgetLimitType budgetType = StringExtensions.parseOptional(budgetTypeRowValue, new Function<String, BudgetLimitType>(){

                    @Override
                    public BudgetLimitType apply(String value) {
                        return BudgetLimitType.fromValue(value);
                    }
                });
                if (budgetType == null) {
                    return;
                }
                String budgetRowValue = values.get("Budget");
                if (budgetRowValue == null) {
                    return;
                }
                Double budgetValue = StringExtensions.nullOrDouble(budgetRowValue);
                c.getCampaign().setBudgetType(budgetType);
                if (BulkCampaign.isDailyBudget(budgetType)) {
                    c.getCampaign().setDailyBudget(budgetValue);
                } else {
                    c.getCampaign().setMonthlyBudget(budgetValue);
                }
            }
        };
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                return c.getCampaign().getId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Status", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getStatus() != null ? c.getCampaign().getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignStatus>(){

                    @Override
                    public CampaignStatus apply(String value) {
                        return CampaignStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Parent Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setAccountId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Campaign", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getName();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Time Zone", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getTimeZone();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setTimeZone(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Budget Type", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getBudgetType() != null ? c.getCampaign().getBudgetType().value() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setBudgetType(StringExtensions.parseOptional(v, new Function<String, BudgetLimitType>(){

                    @Override
                    public BudgetLimitType apply(String value) {
                        return BudgetLimitType.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new ComplexBulkMapping<BulkCampaign>(budgetToCsv, csvToBudget));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

