/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkGenderTargetBid;
import com.microsoft.bingads.bulk.entities.BulkSubTarget;
import com.microsoft.bingads.campaignmanagement.ArrayOfGenderTargetBid;
import com.microsoft.bingads.campaignmanagement.GenderTarget;
import com.microsoft.bingads.campaignmanagement.GenderTargetBid;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import java.util.ArrayList;
import java.util.List;

abstract class BulkGenderTarget<TBid extends BulkGenderTargetBid>
extends BulkSubTarget<TBid> {
    private GenderTarget genderTarget;

    public BulkGenderTarget(Class<TBid> classOfTBid) {
        super(classOfTBid);
    }

    @Override
    void reconstructSubTargets() {
        this.setGenderTarget(new GenderTarget());
        ArrayOfGenderTargetBid bids = new ArrayOfGenderTargetBid();
        this.getGenderTarget().setBids(bids);
        for (BulkGenderTargetBid bid : this.getBids()) {
            bids.getGenderTargetBids().add(bid.getGenderTargetBid());
        }
    }

    @Override
    List<TBid> convertApiToBulkBids() {
        ArrayList<BulkGenderTargetBid> bulkBids = new ArrayList<BulkGenderTargetBid>();
        if (this.getGenderTarget() == null || this.getGenderTarget().getBids() == null) {
            return bulkBids;
        }
        for (final GenderTargetBid apiBid : this.getGenderTarget().getBids().getGenderTargetBids()) {
            BulkGenderTargetBid bulkBid = (BulkGenderTargetBid)this.createAndPopulateBid(new Consumer<TBid>(){

                @Override
                public void accept(TBid t) {
                    ((BulkGenderTargetBid)t).setGenderTargetBid(apiBid);
                }
            });
            bulkBids.add(bulkBid);
        }
        return bulkBids;
    }

    @Override
    void validatePropertiesNotNull() {
        this.validatePropertyNotNull(this.getGenderTarget(), "GenderTarget");
    }

    @Override
    void validateBidsNotNullOrEmpty() {
        if (this.getGenderTarget() != null) {
            this.validateListNotNullOrEmpty(this.getGenderTarget().getBids(), this.getGenderTarget().getBids().getGenderTargetBids(), "GenderTarget.Bids");
        }
    }

    public GenderTarget getGenderTarget() {
        return this.genderTarget;
    }

    public void setGenderTarget(GenderTarget ageTarget) {
        this.genderTarget = ageTarget;
    }
}

