/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkObject;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.functionalinterfaces.Function;

public class BulkError
extends BulkObject {
    private String error;
    private Integer number;
    private String editorialLocation;
    private String editorialTerm;
    private Integer editorialReasonCode;
    private String publisherCountries;

    @Override
    public void readFromRowValues(RowValues values) {
        String status = values.get("Status");
        if (status != null && !status.equals("Deleted")) {
            this.setError(values.get("Error"));
            this.setNumber(Integer.parseInt(values.get("Error Number")));
            this.setEditorialLocation(values.get("Editorial Location"));
            this.setEditorialReasonCode(StringExtensions.parseOptional(values.get("Editorial Reason Code"), new Function<String, Integer>(){

                @Override
                public Integer apply(String value) {
                    return Integer.parseInt(value);
                }
            }));
            this.setEditorialTerm(values.get("Editorial Term"));
            this.setPublisherCountries(values.get("Publisher Countries"));
        }
    }

    public String getError() {
        return this.error;
    }

    public Integer getNumber() {
        return this.number;
    }

    public String getEditorialLocation() {
        return this.editorialLocation;
    }

    public String getEditorialTerm() {
        return this.editorialTerm;
    }

    public Integer getEditorialReasonCode() {
        return this.editorialReasonCode;
    }

    public String getPublisherCountries() {
        return this.publisherCountries;
    }

    private void setError(String error) {
        this.error = error;
    }

    private void setNumber(Integer number) {
        this.number = number;
    }

    private void setEditorialLocation(String editorialLocation) {
        this.editorialLocation = editorialLocation;
    }

    private void setEditorialTerm(String editorialTerm) {
        this.editorialTerm = editorialTerm;
    }

    private void setEditorialReasonCode(Integer editorialReasonCode) {
        this.editorialReasonCode = editorialReasonCode;
    }

    private void setPublisherCountries(String publisherCountries) {
        this.publisherCountries = publisherCountries;
    }
}

