/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkAgeTargetBid;
import com.microsoft.bingads.bulk.entities.BulkSubTarget;
import com.microsoft.bingads.campaignmanagement.AgeTarget;
import com.microsoft.bingads.campaignmanagement.AgeTargetBid;
import com.microsoft.bingads.campaignmanagement.ArrayOfAgeTargetBid;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import java.util.ArrayList;
import java.util.List;

abstract class BulkAgeTarget<TBid extends BulkAgeTargetBid>
extends BulkSubTarget<TBid> {
    private AgeTarget ageTarget;

    public BulkAgeTarget(Class<TBid> classOfTBid) {
        super(classOfTBid);
    }

    @Override
    void reconstructSubTargets() {
        this.setAgeTarget(new AgeTarget());
        ArrayOfAgeTargetBid bids = new ArrayOfAgeTargetBid();
        this.getAgeTarget().setBids(bids);
        for (BulkAgeTargetBid bid : this.getBids()) {
            bids.getAgeTargetBids().add(bid.getAgeTargetBid());
        }
    }

    @Override
    List<TBid> convertApiToBulkBids() {
        ArrayList<BulkAgeTargetBid> bulkBids = new ArrayList<BulkAgeTargetBid>();
        if (this.getAgeTarget() == null || this.getAgeTarget().getBids() == null) {
            return bulkBids;
        }
        for (final AgeTargetBid apiBid : this.getAgeTarget().getBids().getAgeTargetBids()) {
            BulkAgeTargetBid bulkBid = (BulkAgeTargetBid)this.createAndPopulateBid(new Consumer<TBid>(){

                @Override
                public void accept(TBid t) {
                    ((BulkAgeTargetBid)t).setAgeTargetBid(apiBid);
                }
            });
            bulkBids.add(bulkBid);
        }
        return bulkBids;
    }

    @Override
    void validatePropertiesNotNull() {
        this.validatePropertyNotNull(this.getAgeTarget(), "AgeTarget");
    }

    @Override
    void validateBidsNotNullOrEmpty() {
        if (this.getAgeTarget() != null) {
            this.validateListNotNullOrEmpty(this.getAgeTarget().getBids(), this.getAgeTarget().getBids().getAgeTargetBids(), "AgeTarget.Bids");
        }
    }

    public AgeTarget getAgeTarget() {
        return this.ageTarget;
    }

    public void setAgeTarget(AgeTarget ageTarget) {
        this.ageTarget = ageTarget;
    }
}

