/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAd;
import com.microsoft.bingads.v13.campaignmanagement.AdType;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.CallToAction;
import com.microsoft.bingads.v13.campaignmanagement.ResponsiveAd;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkResponsiveAd
extends BulkAd<ResponsiveAd> {
    private static final List<BulkMapping<BulkResponsiveAd>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getResponsiveAd(), ((ResponsiveAd)this.getAd()).getClass().getName());
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAd(new ResponsiveAd());
        ((ResponsiveAd)this.getAd()).setType(AdType.RESPONSIVE_AD);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public ResponsiveAd getResponsiveAd() {
        return (ResponsiveAd)this.ad;
    }

    public void setResponsiveAd(ResponsiveAd ad) {
        this.setAd(ad);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkResponsiveAd, String>> m = new ArrayList<SimpleBulkMapping<BulkResponsiveAd, String>>();
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Business Name", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getBusinessName();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setBusinessName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Call To Action", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getCallToAction() != null ? ((ResponsiveAd)c.getAd()).getCallToAction().value() : null;
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setCallToAction(StringExtensions.parseOptional(v, new Function<String, CallToAction>(){

                    @Override
                    public CallToAction apply(String value) {
                        return CallToAction.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Headline", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getHeadline();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setHeadline(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Images", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return StringExtensions.toImageAssetLinksBulkString(((ResponsiveAd)c.getAd()).getImages());
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setImages(StringExtensions.parseImageAssetLinks(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Long Headline", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getLongHeadlineString();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setLongHeadlineString(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Text", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getText();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Impression Tracking Urls", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return StringExtensions.writeUrls("; ", ((ResponsiveAd)c.getAd()).getImpressionTrackingUrls(), ((ResponsiveAd)c.getAd()).getId());
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((ResponsiveAd)c.getAd()).setImpressionTrackingUrls(urls);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

