/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v13.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v13.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.CashbackAdjustment;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v13.campaignmanagement.CriterionCashback;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkAdGroupBiddableCriterion
extends SingleRecordBulkEntity {
    protected BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupBiddableCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        CashbackAdjustment cashback = new CashbackAdjustment();
        cashback.setType(CashbackAdjustment.class.getSimpleName());
        Criterion criterion = this.createCriterion();
        adGroupCriterion.setCriterion(criterion);
        adGroupCriterion.getCriterion().setType(criterion.getClass().getSimpleName());
        adGroupCriterion.setCriterionBid(bidMultiplier);
        adGroupCriterion.setCriterionCashback(cashback);
        adGroupCriterion.setType("BiddableAdGroupCriterion");
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    protected abstract Criterion createCriterion();

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), BiddableAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion biddableAdGroupCriterion) {
        this.biddableAdGroupCriterion = biddableAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupBiddableCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupBiddableCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupBiddableCriterion, String>("Status", new Function<BulkAdGroupBiddableCriterion, String>(){

            @Override
            public String apply(BulkAdGroupBiddableCriterion c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupBiddableCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupBiddableCriterion c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupBiddableCriterion, Long>("Id", new Function<BulkAdGroupBiddableCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupBiddableCriterion c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupBiddableCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupBiddableCriterion c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupBiddableCriterion, Long>("Parent Id", new Function<BulkAdGroupBiddableCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupBiddableCriterion c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupBiddableCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupBiddableCriterion c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupBiddableCriterion, String>("Campaign", new Function<BulkAdGroupBiddableCriterion, String>(){

            @Override
            public String apply(BulkAdGroupBiddableCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupBiddableCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupBiddableCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupBiddableCriterion, String>("Ad Group", new Function<BulkAdGroupBiddableCriterion, String>(){

            @Override
            public String apply(BulkAdGroupBiddableCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupBiddableCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupBiddableCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupBiddableCriterion, String>("Bid Adjustment", new Function<BulkAdGroupBiddableCriterion, String>(){

            @Override
            public String apply(BulkAdGroupBiddableCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getBiddableAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupBiddableCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupBiddableCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getBiddableAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupBiddableCriterion, String>("Cashback Percent", new Function<BulkAdGroupBiddableCriterion, String>(){

            @Override
            public String apply(BulkAdGroupBiddableCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionCashback cashback = c.getBiddableAdGroupCriterion().getCriterionCashback();
                    if (cashback == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((CashbackAdjustment)cashback).getCashbackPercent());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupBiddableCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupBiddableCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((CashbackAdjustment)c.getBiddableAdGroupCriterion().getCriterionCashback()).setCashbackPercent(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

