/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.ServiceFactory;
import com.microsoft.bingads.internal.ServiceInfo;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.v13.adinsight.IAdInsightService;
import com.microsoft.bingads.v13.bulk.IBulkService;
import com.microsoft.bingads.v13.campaignmanagement.ICampaignManagementService;
import com.microsoft.bingads.v13.customerbilling.ICustomerBillingService;
import com.microsoft.bingads.v13.customermanagement.ICustomerManagementService;
import com.microsoft.bingads.v13.reporting.IReportingService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.spi.Provider;

public class ServiceFactoryImpl
implements ServiceFactory {
    private static final String VERSION = "13.0.8.1";
    private static final int DEFAULT_WS_CREATE_TIMEOUT_IN_SECOND = 60;
    private static final int WS_CREATE_RETRY_INTERVAL_IN_SECOND = 5;
    private static final int WS_CREATE_RETRY_TIMES = 3;
    private static Logger logger = Logger.getLogger(ServiceFactoryImpl.class.getName());
    private static final Map<Class, ServiceInfo> endpoints = new HashMap<Class, ServiceInfo>(){
        {
            this.put(ICustomerBillingService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://clientcenter.api.bingads.microsoft.com/Api/Billing/v13/CustomerBillingService.svc");
                    this.setSandboxUrl("https://clientcenter.api.sandbox.bingads.microsoft.com/Api/Billing/v13/CustomerBillingService.svc");
                }
            });
            this.put(ICustomerManagementService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://clientcenter.api.bingads.microsoft.com/Api/CustomerManagement/v13/CustomerManagementService.svc");
                    this.setSandboxUrl("https://clientcenter.api.sandbox.bingads.microsoft.com/Api/CustomerManagement/v13/CustomerManagementService.svc");
                }
            });
            this.put(IReportingService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://reporting.api.bingads.microsoft.com/Api/Advertiser/Reporting/v13/ReportingService.svc");
                    this.setSandboxUrl("https://reporting.api.sandbox.bingads.microsoft.com/Api/Advertiser/Reporting/v13/ReportingService.svc");
                }
            });
            this.put(ICampaignManagementService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://campaign.api.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v13/CampaignManagementService.svc");
                    this.setSandboxUrl("https://campaign.api.sandbox.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v13/CampaignManagementService.svc");
                }
            });
            this.put(IAdInsightService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://adinsight.api.bingads.microsoft.com/Api/Advertiser/AdInsight/v13/AdInsightService.svc");
                    this.setSandboxUrl("https://adinsight.api.sandbox.bingads.microsoft.com/Api/Advertiser/AdInsight/v13/AdInsightService.svc");
                }
            });
            this.put(IBulkService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://bulk.api.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v13/BulkService.svc");
                    this.setSandboxUrl("https://bulk.api.sandbox.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v13/BulkService.svc");
                }
            });
        }
    };

    @Override
    public Service createService(Class serviceInterface, ApiEnvironment env) {
        try {
            return this.createServiceWithRetry(serviceInterface, env);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Service createServiceWithRetry(Class serviceInterface, ApiEnvironment env) throws Exception {
        block9: {
            final QName qName = this.getServiceQname(serviceInterface);
            final boolean isCxf = Provider.provider().getClass().getName().contains("org.apache.cxf");
            final URL url = isCxf ? null : new URL(this.getServiceUrl(serviceInterface, env) + "?wsdl");
            int retryLeft = 3;
            int timeout = 0;
            ExecutorService pool = Executors.newSingleThreadExecutor();
            while (true) {
                if (retryLeft <= 0) break block9;
                --retryLeft;
                timeout = this.prolongTimeout(timeout);
                Future<Service> future = pool.submit(new Callable<Service>(){

                    @Override
                    public Service call() throws Exception {
                        if (isCxf) {
                            return Service.create((QName)qName);
                        }
                        return Service.create((URL)url, (QName)qName);
                    }
                });
                try {
                    Service service = future.get(timeout, TimeUnit.SECONDS);
                    return service;
                }
                catch (TimeoutException e) {
                    System.out.println(String.format("Timeout. Failed to create web service %s in %d seconds for %s. retry left %d", serviceInterface.getName(), timeout, env.value(), retryLeft));
                    future.cancel(true);
                    try {
                        if (retryLeft <= 0) continue;
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                pool.shutdown();
            }
        }
        throw new Exception(String.format("Failed to create Service %s for %s!", serviceInterface.getName(), env.value()));
    }

    private int prolongTimeout(int timeout) {
        return timeout + 60;
    }

    private String getServiceUrl(Class serviceInterface, ApiEnvironment env) {
        String serviceUrl = this.getServiceUrlFromConfig(serviceInterface);
        if (serviceUrl == null) {
            ServiceInfo serviceInfo = endpoints.get(serviceInterface);
            serviceUrl = serviceInfo.GetUrl(env);
        }
        return serviceUrl;
    }

    private QName getServiceQname(Class serviceInterface) {
        WebService webServiceAnnotation = serviceInterface.getAnnotation(WebService.class);
        String serviceName = webServiceAnnotation.name();
        if (serviceName.startsWith("I")) {
            serviceName = serviceName.substring(1);
        }
        QName qName = new QName(webServiceAnnotation.targetNamespace(), serviceName);
        return qName;
    }

    @Override
    public <T> T createProxyFromService(Service service, ApiEnvironment env, Class<T> serviceInterface) {
        Object port = service.getPort(serviceInterface);
        String serviceUrl = this.getServiceUrl(serviceInterface, env);
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", serviceUrl);
        this.configServiceProxy(port);
        this.addUserAgent(port);
        return (T)port;
    }

    protected <T> void configServiceProxy(T port) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceUrlFromConfig(Class serviceInterface) {
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream(ServiceUtils.getPropertyFile());
            if (input == null) {
                String string = null;
                return string;
            }
            Properties props = new Properties();
            props.load(input);
            String string = props.getProperty(serviceInterface.getCanonicalName() + ".url");
            return string;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "Failed to read propertyFile: " + ServiceUtils.getPropertyFile(), ex);
            String string = null;
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private <T> void addUserAgent(T port) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        String userAgent = "BingAdsSDKJava 13.0.8.1";
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.matches("\\d+[\\d|\\.|\\_]*\\d+")) {
            userAgent = userAgent + " " + javaVersion;
        }
        headers.put("User-Agent", Arrays.asList(userAgent));
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.http.request.headers", headers);
    }
}

