/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v13.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v13.campaignmanagement.NegativeCampaignCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignNegativeAudienceAssociation
extends SingleRecordBulkEntity {
    private NegativeCampaignCriterion negativeCampaignCriterion;
    private String campaignName;
    private String audienceName;
    private static final List<BulkMapping<BulkCampaignNegativeAudienceAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeCampaignCriterion campaignCriterion = new NegativeCampaignCriterion();
        campaignCriterion.setType(NegativeCampaignCriterion.class.getSimpleName());
        AudienceCriterion audienceCriterion = new AudienceCriterion();
        audienceCriterion.setType(AudienceCriterion.class.getSimpleName());
        campaignCriterion.setCriterion(audienceCriterion);
        this.setNegativeCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeCampaignCriterion(), BulkCampaignNegativeAudienceAssociation.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public NegativeCampaignCriterion getNegativeCampaignCriterion() {
        return this.negativeCampaignCriterion;
    }

    public void setNegativeCampaignCriterion(NegativeCampaignCriterion campaignCriterion) {
        this.negativeCampaignCriterion = campaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAudienceName() {
        return this.audienceName;
    }

    public void setAudienceName(String audienceName) {
        this.audienceName = audienceName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, String>("Status", new Function<BulkCampaignNegativeAudienceAssociation, String>(){

            @Override
            public String apply(BulkCampaignNegativeAudienceAssociation c) {
                CampaignCriterionStatus status = c.getNegativeCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignNegativeAudienceAssociation c) {
                c.getNegativeCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, Long>("Id", new Function<BulkCampaignNegativeAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeAudienceAssociation c) {
                return c.getNegativeCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignNegativeAudienceAssociation c) {
                c.getNegativeCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, Long>("Parent Id", new Function<BulkCampaignNegativeAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeAudienceAssociation c) {
                return c.getNegativeCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignNegativeAudienceAssociation c) {
                c.getNegativeCampaignCriterion().setCampaignId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, String>("Campaign", new Function<BulkCampaignNegativeAudienceAssociation, String>(){

            @Override
            public String apply(BulkCampaignNegativeAudienceAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignNegativeAudienceAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, String>("Audience", new Function<BulkCampaignNegativeAudienceAssociation, String>(){

            @Override
            public String apply(BulkCampaignNegativeAudienceAssociation c) {
                return c.getAudienceName();
            }
        }, new BiConsumer<String, BulkCampaignNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignNegativeAudienceAssociation c) {
                c.setAudienceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeAudienceAssociation, Long>("Audience Id", new Function<BulkCampaignNegativeAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeAudienceAssociation c) {
                if (c.getNegativeCampaignCriterion() instanceof NegativeCampaignCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getNegativeCampaignCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignNegativeAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignNegativeAudienceAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getNegativeCampaignCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

