/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.NegativeSite;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkSharedNegativeSite
extends SingleRecordBulkEntity {
    private Long parentId;
    private Status status;
    private NegativeSite negativeSite;
    private static final List<BulkMapping<BulkSharedNegativeSite>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setNegativeSite(new NegativeSite());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeSite(), "NegativeSite");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public NegativeSite getNegativeSite() {
        return this.negativeSite;
    }

    public void setNegativeSite(NegativeSite negativeSite) {
        this.negativeSite = negativeSite;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkSharedNegativeSite, Object>> m = new ArrayList<SimpleBulkMapping<BulkSharedNegativeSite, Object>>();
        m.add(new SimpleBulkMapping<BulkSharedNegativeSite, Long>("Id", new Function<BulkSharedNegativeSite, Long>(){

            @Override
            public Long apply(BulkSharedNegativeSite c) {
                return c.getNegativeSite().getId();
            }
        }, new BiConsumer<String, BulkSharedNegativeSite>(){

            @Override
            public void accept(String v, BulkSharedNegativeSite c) {
                c.getNegativeSite().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSharedNegativeSite, String>("Status", new Function<BulkSharedNegativeSite, String>(){

            @Override
            public String apply(BulkSharedNegativeSite c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkSharedNegativeSite>(){

            @Override
            public void accept(String v, BulkSharedNegativeSite c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return StringExtensions.fromValueOptional(value, Status.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSharedNegativeSite, Long>("Parent Id", new Function<BulkSharedNegativeSite, Long>(){

            @Override
            public Long apply(BulkSharedNegativeSite c) {
                return c.getParentId();
            }
        }, new BiConsumer<String, BulkSharedNegativeSite>(){

            @Override
            public void accept(String v, BulkSharedNegativeSite c) {
                c.setParentId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSharedNegativeSite, String>("Site List Item Url", new Function<BulkSharedNegativeSite, String>(){

            @Override
            public String apply(BulkSharedNegativeSite c) {
                return c.getNegativeSite().getUrl();
            }
        }, new BiConsumer<String, BulkSharedNegativeSite>(){

            @Override
            public void accept(String v, BulkSharedNegativeSite c) {
                c.getNegativeSite().setUrl(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

