/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkCampaignBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.GenderCriterion;
import com.microsoft.bingads.v13.campaignmanagement.GenderType;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignGenderCriterion
extends BulkCampaignBiddableCriterion {
    private static final List<BulkMapping<BulkCampaignGenderCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    protected Criterion createCriterion() {
        return new GenderCriterion();
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignGenderCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkCampaignGenderCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkCampaignGenderCriterion, String>("Target", new Function<BulkCampaignGenderCriterion, String>(){

            @Override
            public String apply(BulkCampaignGenderCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof GenderCriterion) {
                    GenderType genderType = ((GenderCriterion)c.getBiddableCampaignCriterion().getCriterion()).getGenderType();
                    return genderType == null ? null : genderType.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignGenderCriterion>(){

            @Override
            public void accept(String v, BulkCampaignGenderCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof GenderCriterion) {
                    ((GenderCriterion)c.getBiddableCampaignCriterion().getCriterion()).setGenderType(StringExtensions.parseOptional(v, new Function<String, GenderType>(){

                        @Override
                        public GenderType apply(String s) {
                            return StringExtensions.fromValueOptional(s, GenderType.class);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

