/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.ServiceClient;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.internal.functionalinterfaces.TriConsumer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class OperationStatusRetry<TOperationStatus, TOperationStatusProvider, TService> {
    private static final int INTERVAL_OF_RETRY = 1000;
    private static final int[] INTERVAL_OF_RETRY_RATE_LIMIT = new int[]{15000, 20000, 25000, 30000};
    private static final int RATELIMIT_CODE = 117;
    private ScheduledExecutorService executor;
    private Function<Exception, Integer> errorCodeFunc;

    public OperationStatusRetry(Function<Exception, Integer> f) {
        this.errorCodeFunc = f;
    }

    public void executeWithRetry(TriConsumer<TOperationStatusProvider, ServiceClient<TService>, AsyncCallback<TOperationStatus>> action, TOperationStatusProvider statusProvider, ServiceClient<TService> serviceClient, Consumer<TOperationStatus> statusConsumer, Consumer<Exception> exceptionConsumer, int maxRetryCount) {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.doPollOperationStatus(action, statusProvider, serviceClient, statusConsumer, exceptionConsumer, maxRetryCount);
    }

    private void doPollOperationStatus(final TriConsumer<TOperationStatusProvider, ServiceClient<TService>, AsyncCallback<TOperationStatus>> action, final TOperationStatusProvider statusProvider, final ServiceClient<TService> serviceClient, final Consumer<TOperationStatus> statusConsumer, final Consumer<Exception> exceptionConsumer, final int maxRetryCount) {
        action.accept(statusProvider, serviceClient, new AsyncCallback<TOperationStatus>(){

            @Override
            public void onCompleted(Future<TOperationStatus> result) {
                try {
                    statusConsumer.accept(result.get());
                    OperationStatusRetry.this.executor.shutdown();
                }
                catch (InterruptedException exception) {
                    this.retryWhenException(action, statusProvider, serviceClient, statusConsumer, exceptionConsumer, maxRetryCount, exception);
                }
                catch (ExecutionException exception) {
                    this.retryWhenException(action, statusProvider, serviceClient, statusConsumer, exceptionConsumer, maxRetryCount, exception);
                }
            }

            private void retryWhenException(TriConsumer<TOperationStatusProvider, ServiceClient<TService>, AsyncCallback<TOperationStatus>> action2, TOperationStatusProvider statusProvider2, ServiceClient<TService> serviceClient2, Consumer<TOperationStatus> statusConsumer2, Consumer<Exception> exceptionConsumer2, int maxRetryCount2, Exception exception) {
                if (maxRetryCount2 > 0) {
                    OperationStatusRetry.this.retry(action2, statusProvider2, serviceClient2, statusConsumer2, exceptionConsumer2, maxRetryCount2 - 1, exception);
                } else {
                    OperationStatusRetry.this.executor.shutdown();
                    exceptionConsumer2.accept(exception);
                }
            }
        });
    }

    private void retry(final TriConsumer<TOperationStatusProvider, ServiceClient<TService>, AsyncCallback<TOperationStatus>> action, final TOperationStatusProvider statusProvider, final ServiceClient<TService> serviceClient, final Consumer<TOperationStatus> statusConsumer, final Consumer<Exception> exceptionConsumer, final int maxRetryCount, Exception exception) {
        int interval = this.getInterval(exception, maxRetryCount);
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                OperationStatusRetry.this.doPollOperationStatus(action, statusProvider, serviceClient, statusConsumer, exceptionConsumer, maxRetryCount);
            }
        }, (long)interval, TimeUnit.MILLISECONDS);
    }

    private int getInterval(Exception exception, int maxRetryCount) {
        int errorCode = this.errorCodeFunc.apply(exception);
        if (errorCode == 117) {
            return INTERVAL_OF_RETRY_RATE_LIMIT[INTERVAL_OF_RETRY_RATE_LIMIT.length - 1 - maxRetryCount];
        }
        return 1000;
    }
}

