/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.Site;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkSharedSite
extends SingleRecordBulkEntity {
    private Long parentId;
    private Status status;
    private Site site;
    private static final List<BulkMapping<BulkSharedSite>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setSite(new Site());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getSite(), "Site");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Site getSite() {
        return this.site;
    }

    public void setSite(Site site) {
        this.site = site;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkSharedSite, Object>> m = new ArrayList<SimpleBulkMapping<BulkSharedSite, Object>>();
        m.add(new SimpleBulkMapping<BulkSharedSite, Long>("Id", new Function<BulkSharedSite, Long>(){

            @Override
            public Long apply(BulkSharedSite c) {
                return c.getSite().getId();
            }
        }, new BiConsumer<String, BulkSharedSite>(){

            @Override
            public void accept(String v, BulkSharedSite c) {
                c.getSite().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSharedSite, String>("Status", new Function<BulkSharedSite, String>(){

            @Override
            public String apply(BulkSharedSite c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkSharedSite>(){

            @Override
            public void accept(String v, BulkSharedSite c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return StringExtensions.fromValueOptional(value, Status.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSharedSite, Long>("Parent Id", new Function<BulkSharedSite, Long>(){

            @Override
            public Long apply(BulkSharedSite c) {
                return c.getParentId();
            }
        }, new BiConsumer<String, BulkSharedSite>(){

            @Override
            public void accept(String v, BulkSharedSite c) {
                c.setParentId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSharedSite, String>("Site List Item Url", new Function<BulkSharedSite, String>(){

            @Override
            public String apply(BulkSharedSite c) {
                return c.getSite().getUrl();
            }
        }, new BiConsumer<String, BulkSharedSite>(){

            @Override
            public void accept(String v, BulkSharedSite c) {
                c.getSite().setUrl(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

