/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAudience;
import com.microsoft.bingads.v13.campaignmanagement.ProductAudience;
import com.microsoft.bingads.v13.campaignmanagement.ProductAudienceType;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BulkProductAudience
extends BulkAudience<ProductAudience> {
    private static final List<BulkMapping<BulkProductAudience>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public ProductAudience getProductAudience() {
        return (ProductAudience)this.getAudience();
    }

    public void setProductAudience(ProductAudience productAudience) {
        this.setAudience(productAudience);
    }

    @Override
    public ProductAudience createAudience() {
        return new ProductAudience();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkProductAudience, Object>> m = new ArrayList<SimpleBulkMapping<BulkProductAudience, Object>>();
        m.add(new SimpleBulkMapping<BulkProductAudience, Long>("UET Tag Id", new Function<BulkProductAudience, Long>(){

            @Override
            public Long apply(BulkProductAudience c) {
                return c.getProductAudience().getTagId();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setTagId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, String>("Product Audience Type", new Function<BulkProductAudience, String>(){

            @Override
            public String apply(BulkProductAudience c) {
                Collection<ProductAudienceType> productAudienceTypes = c.getProductAudience().getProductAudienceType();
                if (productAudienceTypes == null || productAudienceTypes.size() == 0) {
                    return null;
                }
                if (productAudienceTypes.size() != 1) {
                    throw new IllegalArgumentException("Only 1 Product Audience Type can be set in ProductAudience");
                }
                return productAudienceTypes.toArray(new ProductAudienceType[productAudienceTypes.size()])[0].value();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                ProductAudienceType productAudienceType = StringExtensions.parseOptional(v, new Function<String, ProductAudienceType>(){

                    @Override
                    public ProductAudienceType apply(String value) {
                        return StringExtensions.fromValueOptional(value, ProductAudienceType.class);
                    }
                });
                if (productAudienceType != null) {
                    c.getProductAudience().setProductAudienceType(Collections.singleton(productAudienceType));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

