/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.Authentication;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.HeadersImpl;
import com.microsoft.bingads.RestfulServiceFactory;
import com.microsoft.bingads.internal.HeaderHandler;
import com.microsoft.bingads.internal.MessageHandler;
import com.microsoft.bingads.internal.OAuthWithAuthorizationCode;
import com.microsoft.bingads.internal.ServiceFactory;
import com.microsoft.bingads.internal.ServiceFactoryFactory;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.internal.utilities.Lazy;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.handler.PortInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceClient<T> {
    private final AuthorizationData authorizationData;
    private final Class<T> serviceInterface;
    private final ServiceFactory serviceFactory;
    private ApiEnvironment environment;
    private final Lazy<Service> service;

    public ApiEnvironment getEnvironment() {
        return this.environment;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    private static boolean getDisableRestApi(Class<?> serviceClass) {
        return ServiceUtils.getDisableRestApi(serviceClass);
    }

    public ServiceClient(AuthorizationData authorizationData, Class<T> serviceInterface) {
        this(authorizationData, null, serviceInterface);
    }

    public ServiceClient(AuthorizationData authorizationData, ApiEnvironment environment, Class<T> serviceInterface) {
        this.authorizationData = authorizationData;
        this.serviceInterface = serviceInterface;
        if (environment == null && authorizationData.getAuthentication() != null) {
            environment = authorizationData.getAuthentication().getEnvironment();
        }
        if (environment == null) {
            environment = ServiceUtils.getEnvironmentFromConfig();
        }
        if (environment == null) {
            environment = ApiEnvironment.PRODUCTION;
        }
        this.environment = environment;
        this.serviceFactory = ServiceFactoryFactory.createServiceFactory();
        this.service = new Lazy<Service>(() -> {
            Service newService = this.serviceFactory.createService(this.serviceInterface, this.environment);
            newService.setHandlerResolver(new HandlerResolver(){

                public List<Handler> getHandlerChain(PortInfo portInfo) {
                    return Arrays.asList(HeaderHandler.getInstance(), MessageHandler.getInstance());
                }
            });
            return newService;
        });
    }

    public T getService() {
        this.authorizationData.validate();
        Map<String, String> headers = this.buildHeaders();
        if (ServiceClient.getDisableRestApi(this.serviceInterface)) {
            return this.createSoapPort(headers);
        }
        return this.createRestService(headers);
    }

    private Map<String, String> buildHeaders() {
        final HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CustomerAccountId", Long.toString(this.authorizationData.getAccountId()));
        headers.put("CustomerId", Long.toString(this.authorizationData.getCustomerId()));
        headers.put("DeveloperToken", this.authorizationData.getDeveloperToken());
        Authentication authentication = this.authorizationData.getAuthentication();
        if (authentication instanceof OAuthWithAuthorizationCode) {
            ((OAuthWithAuthorizationCode)authentication).refreshTokensIfNeeded(false);
        }
        authentication.addHeaders(new HeadersImpl(){

            @Override
            public void addHeader(String name, String value) {
                headers.put(name, value);
            }
        });
        return headers;
    }

    T createSoapPort(Map<String, String> headers) {
        T port = this.serviceFactory.createProxyFromService(this.service.getValue(), this.environment, this.serviceInterface);
        ((BindingProvider)port).getRequestContext().put(ServiceUtils.REQUEST_HEADERS_KEY, headers);
        return port;
    }

    T createRestService(Map<String, String> headers) {
        return (T)RestfulServiceFactory.createServiceClient(headers, this.environment, this.serviceInterface, () -> this.createSoapPort(headers));
    }
}

