/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkConversionGoal;
import com.microsoft.bingads.v13.campaignmanagement.PagesViewedPerVisitGoal;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkPagesViewedPerVisitGoal
extends BulkConversionGoal<PagesViewedPerVisitGoal> {
    private static final List<BulkMapping<BulkPagesViewedPerVisitGoal>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public PagesViewedPerVisitGoal getPagesViewedPerVisitGoal() {
        return (PagesViewedPerVisitGoal)this.getConversionGoal();
    }

    public void setPagesViewedPerVisitGoal(PagesViewedPerVisitGoal PagesViewedPerVisitGoal2) {
        this.setConversionGoal(PagesViewedPerVisitGoal2);
    }

    @Override
    public PagesViewedPerVisitGoal createConversionGoal() {
        return new PagesViewedPerVisitGoal();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkPagesViewedPerVisitGoal, Integer>> m = new ArrayList<SimpleBulkMapping<BulkPagesViewedPerVisitGoal, Integer>>();
        m.add(new SimpleBulkMapping<BulkPagesViewedPerVisitGoal, Integer>("Minimum Pages Viewed", new Function<BulkPagesViewedPerVisitGoal, Integer>(){

            @Override
            public Integer apply(BulkPagesViewedPerVisitGoal c) {
                return ((PagesViewedPerVisitGoal)c.getConversionGoal()).getMinimumPagesViewed();
            }
        }, new BiConsumer<String, BulkPagesViewedPerVisitGoal>(){

            @Override
            public void accept(String v, BulkPagesViewedPerVisitGoal c) {
                ((PagesViewedPerVisitGoal)c.getConversionGoal()).setMinimumPagesViewed(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

