/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful.adaptor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarDeserializer
extends StdDeserializer<Calendar> {
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public CalendarDeserializer() {
        this(null);
    }

    public CalendarDeserializer(Class<?> t) {
        super(t);
    }

    public Calendar deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String str = p.getText();
        str = str.replaceAll("\\.\\d+", "");
        try {
            String dateTime = str.substring(0, 19);
            String zone = str.length() > 19 ? str.substring(19, str.length()) : null;
            Calendar calendar = Calendar.getInstance();
            TimeZone timeZone = TimeZone.getTimeZone("UTC");
            if (zone == null || zone.contains("Z")) {
                calendar.setTimeZone(timeZone);
            } else if (zone != null && (zone.contains("+") || zone.contains("-"))) {
                timeZone = TimeZone.getTimeZone("GMT" + zone.substring(0, 3));
            }
            this.formatter.setTimeZone(timeZone);
            calendar.setTimeZone(timeZone);
            Date date = this.formatter.parse(dateTime);
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

