/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.HeadersImpl;
import com.microsoft.bingads.RestfulServiceFactory;
import com.microsoft.bingads.internal.HeaderHandler;
import com.microsoft.bingads.internal.MessageHandler;
import com.microsoft.bingads.internal.OAuthWithAuthorizationCode;
import com.microsoft.bingads.internal.ServiceFactory;
import com.microsoft.bingads.internal.ServiceFactoryFactory;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.internal.restful.RestfulServiceClient;
import com.microsoft.bingads.v13.adinsight.IAdInsightService;
import com.microsoft.bingads.v13.bulk.IBulkService;
import com.microsoft.bingads.v13.campaignmanagement.ICampaignManagementService;
import com.microsoft.bingads.v13.customerbilling.ICustomerBillingService;
import com.microsoft.bingads.v13.customermanagement.ICustomerManagementService;
import com.microsoft.bingads.v13.reporting.IReportingService;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.handler.PortInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class ServiceClient<T> {
    private static Logger logger = Logger.getLogger(ServiceClient.class.getName());
    private final AuthorizationData authorizationData;
    private final Class<T> serviceInterface;
    private final Service service;
    private final ServiceFactory serviceFactory;
    private ApiEnvironment environment;
    private RestfulServiceClient restService;
    private static HashMap<Class<?>, Boolean> EnableRestApiDefault = new HashMap<Class<?>, Boolean>(){
        {
            this.put(ICampaignManagementService.class, false);
            this.put(IBulkService.class, false);
            this.put(IReportingService.class, false);
            this.put(ICustomerManagementService.class, false);
            this.put(ICustomerBillingService.class, false);
            this.put(IAdInsightService.class, false);
        }
    };

    public ApiEnvironment getEnvironment() {
        return this.environment;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public static void setRestApiEnabledDefault(Class<?> serviceClass, boolean restApiEnabled) {
        EnableRestApiDefault.replace(serviceClass, restApiEnabled);
    }

    public static boolean getRestApiEnabledDefault(Class<?> serviceClass) {
        Boolean restApiEnabled = EnableRestApiDefault.get(serviceClass);
        if (restApiEnabled == null) {
            return false;
        }
        return restApiEnabled;
    }

    public ServiceClient(AuthorizationData authorizationData, Class<T> serviceInterface) {
        this(authorizationData, null, serviceInterface, ServiceClient.getRestApiEnabledDefault(serviceInterface));
    }

    public ServiceClient(AuthorizationData authorizationData, ApiEnvironment environment, Class<T> serviceInterface) {
        this(authorizationData, environment, serviceInterface, ServiceClient.getRestApiEnabledDefault(serviceInterface));
    }

    public ServiceClient(AuthorizationData authorizationData, ApiEnvironment environment, Class<T> serviceInterface, boolean enableRestApi) {
        this.authorizationData = authorizationData;
        this.serviceInterface = serviceInterface;
        if (environment == null && authorizationData.getAuthentication() != null) {
            environment = authorizationData.getAuthentication().getEnvironment();
        }
        if (environment == null) {
            environment = ServiceUtils.getEnvironmentFromConfig();
        }
        if (environment == null) {
            environment = ApiEnvironment.PRODUCTION;
        }
        this.environment = environment;
        this.serviceFactory = ServiceFactoryFactory.createServiceFactory();
        this.service = this.serviceFactory.createService(serviceInterface, environment);
        this.service.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                return Arrays.asList(HeaderHandler.getInstance(), MessageHandler.getInstance());
            }
        });
        if (enableRestApi) {
            this.restService = RestfulServiceFactory.createServiceClient(authorizationData, environment, serviceInterface);
        }
    }

    public T getService() {
        this.authorizationData.validate();
        final HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CustomerAccountId", Long.toString(this.authorizationData.getAccountId()));
        headers.put("CustomerId", Long.toString(this.authorizationData.getCustomerId()));
        headers.put("DeveloperToken", this.authorizationData.getDeveloperToken());
        this.refreshOAuthTokensIfNeeded();
        this.authorizationData.getAuthentication().addHeaders(new HeadersImpl(){

            @Override
            public void addHeader(String name, String value) {
                headers.put(name, value);
            }
        });
        T port = this.serviceFactory.createProxyFromService(this.service, this.environment, this.serviceInterface);
        ((BindingProvider)port).getRequestContext().put(ServiceUtils.REQUEST_HEADERS_KEY, headers);
        if (this.restService == null) {
            return port;
        }
        this.restService.setSoapService(port);
        return (T)Proxy.newProxyInstance(port.getClass().getClassLoader(), port.getClass().getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                Method delegationMethod = ServiceClient.this.restService.getClass().getMethod(methodName, method.getParameterTypes());
                Object response = null;
                try {
                    response = delegationMethod.invoke((Object)ServiceClient.this.restService, args);
                }
                catch (Exception e) {
                    throw e.getCause();
                }
                return response;
            }
        });
    }

    private void refreshOAuthTokensIfNeeded() {
        if (this.authorizationData.getAuthentication() instanceof OAuthWithAuthorizationCode) {
            OAuthWithAuthorizationCode auth = (OAuthWithAuthorizationCode)this.authorizationData.getAuthentication();
            auth.refreshTokensIfNeeded(false);
        }
    }
}

