/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import jakarta.xml.ws.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class ServiceUtils {
    public static final String PROPERTY_FILE_PROPERTY = "PROPERTY_FILE";
    public static final String PROPERTY_FILE = "bingads.properties";
    public static String TRACKING_KEY = "com.microsoft.bingads.trackingId";
    public static String TRACKING_HEADER_NAME = "TrackingId";

    public static String GetTrackingId(Response response) {
        Map context = response.getContext();
        return context.get(TRACKING_KEY).toString();
    }

    public static String getPropertyFile() {
        String file = System.getProperty(PROPERTY_FILE_PROPERTY);
        if (file == null || file.length() == 0) {
            return PROPERTY_FILE;
        }
        return file;
    }

    public static void setPropertyFile(String file) {
        if (file != null && file.length() > 0) {
            System.setProperty(PROPERTY_FILE_PROPERTY, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiEnvironment getEnvironmentFromConfig() {
        InputStream input = null;
        try {
            input = ServiceUtils.class.getClassLoader().getResourceAsStream(ServiceUtils.getPropertyFile());
            if (input == null) {
                ApiEnvironment apiEnvironment = null;
                return apiEnvironment;
            }
            Properties props = new Properties();
            props.load(input);
            String envString = props.getProperty("environment");
            if (envString == null) {
                ApiEnvironment apiEnvironment = null;
                return apiEnvironment;
            }
            ApiEnvironment apiEnvironment = ApiEnvironment.fromValue(envString);
            return apiEnvironment;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            ApiEnvironment apiEnvironment = null;
            return apiEnvironment;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                throw new InternalException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServiceUrlFromConfig(Class serviceInterface) {
        InputStream input = null;
        try {
            File file = new File(ServiceUtils.getPropertyFile());
            if (!file.exists()) {
                String string = null;
                return string;
            }
            input = new FileInputStream(file);
            Properties props = new Properties();
            props.load(input);
            String ex = props.getProperty(serviceInterface.getCanonicalName() + ".url");
            return ex;
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getFallbackFlag() {
        InputStream input = null;
        try {
            File file = new File(ServiceUtils.getPropertyFile());
            if (!file.exists()) {
                boolean bl = true;
                return bl;
            }
            input = new FileInputStream(file);
            Properties props = new Properties();
            props.load(input);
            if (props.getProperty("EnableFallbackToSoap") == null) {
                boolean ex = true;
                return ex;
            }
            boolean ex = Boolean.valueOf(props.getProperty("EnableFallbackToSoap"));
            return ex;
        }
        catch (IOException ex) {
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserAgent() {
        InputStream input = null;
        try {
            File file = new File(ServiceUtils.getPropertyFile());
            if (!file.exists()) {
                String string = null;
                return string;
            }
            input = new FileInputStream(file);
            Properties props = new Properties();
            props.load(input);
            if (props.getProperty("UserAgent") == null) {
                String ex = null;
                return ex;
            }
            String ex = props.getProperty("UserAgent").toString();
            return ex;
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
    }
}

