/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.AssetGroupListingGroup;
import com.microsoft.bingads.v13.campaignmanagement.AssetGroupListingType;
import com.microsoft.bingads.v13.campaignmanagement.ProductCondition;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAssetGroupListingGroup
extends SingleRecordBulkEntity {
    private Status status;
    private String assetGroupName;
    private String campaignName;
    private AssetGroupListingGroup AssetGroupListingGroup;
    private static final List<BulkMapping<BulkAssetGroupListingGroup>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        AssetGroupListingGroup assetGroupListingGroup = new AssetGroupListingGroup();
        assetGroupListingGroup.setDimension(new ProductCondition());
        this.setAssetGroupListingGroup(assetGroupListingGroup);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAssetGroupListingGroup(), "AssetGroupListingGroup");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public AssetGroupListingGroup getAssetGroupListingGroup() {
        return this.AssetGroupListingGroup;
    }

    public void setAssetGroupListingGroup(AssetGroupListingGroup AssetGroupListingGroup2) {
        this.AssetGroupListingGroup = AssetGroupListingGroup2;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getAssetGroupName() {
        return this.assetGroupName;
    }

    public void setAssetGroupName(String assetGroupName) {
        this.assetGroupName = assetGroupName;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAssetGroupListingGroup, Object>> m = new ArrayList<SimpleBulkMapping<BulkAssetGroupListingGroup, Object>>();
        m.add(new SimpleBulkMapping<BulkAssetGroupListingGroup, String>("Status", new Function<BulkAssetGroupListingGroup, String>(){

            @Override
            public String apply(BulkAssetGroupListingGroup c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAssetGroupListingGroup>(){

            @Override
            public void accept(String v, BulkAssetGroupListingGroup c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroupListingGroup, Long>("Id", new Function<BulkAssetGroupListingGroup, Long>(){

            @Override
            public Long apply(BulkAssetGroupListingGroup c) {
                return c.getAssetGroupListingGroup().getId();
            }
        }, new BiConsumer<String, BulkAssetGroupListingGroup>(){

            @Override
            public void accept(String v, BulkAssetGroupListingGroup c) {
                c.getAssetGroupListingGroup().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroupListingGroup, Long>("Parent Id", new Function<BulkAssetGroupListingGroup, Long>(){

            @Override
            public Long apply(BulkAssetGroupListingGroup c) {
                return c.getAssetGroupListingGroup().getAssetGroupId();
            }
        }, new BiConsumer<String, BulkAssetGroupListingGroup>(){

            @Override
            public void accept(String v, BulkAssetGroupListingGroup c) {
                c.getAssetGroupListingGroup().setAssetGroupId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroupListingGroup, String>("Asset Group", new Function<BulkAssetGroupListingGroup, String>(){

            @Override
            public String apply(BulkAssetGroupListingGroup c) {
                return c.getAssetGroupName();
            }
        }, new BiConsumer<String, BulkAssetGroupListingGroup>(){

            @Override
            public void accept(String v, BulkAssetGroupListingGroup c) {
                c.setAssetGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroupListingGroup, String>("Campaign", new Function<BulkAssetGroupListingGroup, String>(){

            @Override
            public String apply(BulkAssetGroupListingGroup c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAssetGroupListingGroup>(){

            @Override
            public void accept(String v, BulkAssetGroupListingGroup c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroupListingGroup, String>("Is Excluded", new Function<BulkAssetGroupListingGroup, String>(){

            @Override
            public String apply(BulkAssetGroupListingGroup c) {
                return StringExtensions.toBooleanBulkString(c.getAssetGroupListingGroup().getIsExcluded());
            }
        }, new BiConsumer<String, BulkAssetGroupListingGroup>(){

            @Override
            public void accept(String v, BulkAssetGroupListingGroup c) {
                c.getAssetGroupListingGroup().setIsExcluded(StringExtensions.parseOptional(v, new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String value) {
                        return Boolean.parseBoolean(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroupListingGroup, Long>("Parent Listing Group Id", new Function<BulkAssetGroupListingGroup, Long>(){

            @Override
            public Long apply(BulkAssetGroupListingGroup c) {
                return c.getAssetGroupListingGroup().getParentListingGroupId();
            }
        }, new BiConsumer<String, BulkAssetGroupListingGroup>(){

            @Override
            public void accept(String v, BulkAssetGroupListingGroup c) {
                c.getAssetGroupListingGroup().setParentListingGroupId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroupListingGroup, String>("Sub Type", new Function<BulkAssetGroupListingGroup, String>(){

            @Override
            public String apply(BulkAssetGroupListingGroup c) {
                return c.getAssetGroupListingGroup().getAssetGroupListingType() != null ? c.getAssetGroupListingGroup().getAssetGroupListingType().value() : null;
            }
        }, new BiConsumer<String, BulkAssetGroupListingGroup>(){

            @Override
            public void accept(String v, BulkAssetGroupListingGroup c) {
                c.getAssetGroupListingGroup().setAssetGroupListingType(StringExtensions.parseOptional(v, new Function<String, AssetGroupListingType>(){

                    @Override
                    public AssetGroupListingType apply(String value) {
                        return AssetGroupListingType.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroupListingGroup, String>("Product Condition 1", new Function<BulkAssetGroupListingGroup, String>(){

            @Override
            public String apply(BulkAssetGroupListingGroup c) {
                ProductCondition productCondition = c.getAssetGroupListingGroup().getDimension();
                return productCondition == null ? null : productCondition.getOperand();
            }
        }, new BiConsumer<String, BulkAssetGroupListingGroup>(){

            @Override
            public void accept(String v, BulkAssetGroupListingGroup c) {
                c.getAssetGroupListingGroup().getDimension().setOperand(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroupListingGroup, String>("Product Value 1", new Function<BulkAssetGroupListingGroup, String>(){

            @Override
            public String apply(BulkAssetGroupListingGroup c) {
                ProductCondition productCondition = c.getAssetGroupListingGroup().getDimension();
                return productCondition == null ? null : productCondition.getAttribute();
            }
        }, new BiConsumer<String, BulkAssetGroupListingGroup>(){

            @Override
            public void accept(String v, BulkAssetGroupListingGroup c) {
                c.getAssetGroupListingGroup().getDimension().setAttribute(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

