/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAd;
import com.microsoft.bingads.v13.campaignmanagement.AdType;
import com.microsoft.bingads.v13.campaignmanagement.ProductAd;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkProductAd
extends BulkAd<ProductAd> {
    private static final List<BulkMapping<BulkProductAd>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getProductAd(), "ProductAd");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAd(new ProductAd());
        ((ProductAd)this.getAd()).setType(AdType.PRODUCT);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public ProductAd getProductAd() {
        return (ProductAd)this.ad;
    }

    public void setProductAd(ProductAd ad) {
        this.setAd(ad);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkProductAd, String>> m = new ArrayList<SimpleBulkMapping<BulkProductAd, String>>();
        m.add(new SimpleBulkMapping<BulkProductAd, String>("Promotion", new Function<BulkProductAd, String>(){

            @Override
            public String apply(BulkProductAd c) {
                return ((ProductAd)c.getAd()).getPromotionalText();
            }
        }, new BiConsumer<String, BulkProductAd>(){

            @Override
            public void accept(String v, BulkProductAd c) {
                ((ProductAd)c.getAd()).setPromotionalText(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

