/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk;

import com.microsoft.bingads.v13.bulk.DownloadStatus;
import com.microsoft.bingads.v13.bulk.OperationError;
import java.util.List;

public class BulkDownloadCouldNotBeCompletedException
extends RuntimeException {
    private final List<OperationError> errors;
    private final DownloadStatus status;

    public BulkDownloadCouldNotBeCompletedException(List<OperationError> errors, DownloadStatus status) {
        this.errors = errors;
        this.status = status;
    }

    public BulkDownloadCouldNotBeCompletedException(List<OperationError> errors, DownloadStatus status, String message) {
        super(message);
        this.errors = errors;
        this.status = status;
    }

    public List<OperationError> getErrors() {
        return this.errors;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        StringBuilder errorsInfo = new StringBuilder();
        for (OperationError error : this.errors) {
            errorsInfo.append(String.format("code=%d, details=%s, errorCode=%s, message=%s; ", error.getCode(), error.getDetails(), error.getErrorCode(), error.getMessage()));
        }
        return String.format("%s Download status is %s, errors are %s", new Object[]{super.toString(), this.status, errorsInfo});
    }
}

