/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAd;
import com.microsoft.bingads.v13.campaignmanagement.AdType;
import com.microsoft.bingads.v13.campaignmanagement.DynamicSearchAd;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkDynamicSearchAd
extends BulkAd<DynamicSearchAd> {
    private static final List<BulkMapping<BulkDynamicSearchAd>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getDynamicSearchAd(), "DynamicSearchAd");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAd(new DynamicSearchAd());
        ((DynamicSearchAd)this.getAd()).setType(AdType.DYNAMIC_SEARCH);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public DynamicSearchAd getDynamicSearchAd() {
        return (DynamicSearchAd)this.ad;
    }

    public void setDynamicSearchAd(DynamicSearchAd ad) {
        this.setAd(ad);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkDynamicSearchAd, String>> m = new ArrayList<SimpleBulkMapping<BulkDynamicSearchAd, String>>();
        m.add(new SimpleBulkMapping<BulkDynamicSearchAd, String>("Text", new Function<BulkDynamicSearchAd, String>(){

            @Override
            public String apply(BulkDynamicSearchAd c) {
                return ((DynamicSearchAd)c.getAd()).getText();
            }
        }, new BiConsumer<String, BulkDynamicSearchAd>(){

            @Override
            public void accept(String v, BulkDynamicSearchAd c) {
                ((DynamicSearchAd)c.getAd()).setText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkDynamicSearchAd, String>("Path 1", new Function<BulkDynamicSearchAd, String>(){

            @Override
            public String apply(BulkDynamicSearchAd c) {
                return ((DynamicSearchAd)c.getAd()).getPath1();
            }
        }, new BiConsumer<String, BulkDynamicSearchAd>(){

            @Override
            public void accept(String v, BulkDynamicSearchAd c) {
                ((DynamicSearchAd)c.getAd()).setPath1(v);
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkDynamicSearchAd, String>("Path 2", new Function<BulkDynamicSearchAd, String>(){

            @Override
            public String apply(BulkDynamicSearchAd c) {
                return ((DynamicSearchAd)c.getAd()).getPath2();
            }
        }, new BiConsumer<String, BulkDynamicSearchAd>(){

            @Override
            public void accept(String v, BulkDynamicSearchAd c) {
                ((DynamicSearchAd)c.getAd()).setPath2(v);
            }
        }, true));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

