/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.campaignmanagement.AdExtension;
import com.microsoft.bingads.v12.campaignmanagement.AdExtensionStatus;
import com.microsoft.bingads.v12.campaignmanagement.Schedule;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BulkAdExtension<T extends AdExtension>
extends SingleRecordBulkEntity {
    private Long accountId;
    private T adExtension;
    private static final List<BulkMapping<BulkAdExtension>> MAPPINGS;

    BulkAdExtension() {
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    protected T getAdExtension() {
        return this.adExtension;
    }

    protected void setAdExtension(T adExtension) {
        this.adExtension = adExtension;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdExtension, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdExtension, Object>>();
        m.add(new SimpleBulkMapping<BulkAdExtension, String>("Status", new Function<BulkAdExtension, String>(){

            @Override
            public String apply(BulkAdExtension c) {
                return StringExtensions.toAdExtensionStatusBulkString(((AdExtension)c.getAdExtension()).getStatus());
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                ((AdExtension)c.getAdExtension()).setStatus(StringExtensions.parseOptional(v, new Function<String, AdExtensionStatus>(){

                    @Override
                    public AdExtensionStatus apply(String value) {
                        return AdExtensionStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtension, Long>("Id", new Function<BulkAdExtension, Long>(){

            @Override
            public Long apply(BulkAdExtension c) {
                return ((AdExtension)c.getAdExtension()).getId();
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                ((AdExtension)c.getAdExtension()).setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtension, Long>("Parent Id", new Function<BulkAdExtension, Long>(){

            @Override
            public Long apply(BulkAdExtension c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                c.setAccountId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtension, Integer>("Version", new Function<BulkAdExtension, Integer>(){

            @Override
            public Integer apply(BulkAdExtension t) {
                return ((AdExtension)t.getAdExtension()).getVersion();
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                ((AdExtension)c.getAdExtension()).setVersion(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtension, String>("Ad Schedule", new Function<BulkAdExtension, String>(){

            @Override
            public String apply(BulkAdExtension t) {
                if (((AdExtension)t.getAdExtension()).getScheduling() == null) {
                    return null;
                }
                return StringExtensions.toDayTimeRangesBulkString(((AdExtension)t.getAdExtension()).getScheduling().getDayTimeRanges(), ((AdExtension)t.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                if (((AdExtension)c.getAdExtension()).getScheduling() == null) {
                    ((AdExtension)c.getAdExtension()).setScheduling(new Schedule());
                }
                ((AdExtension)c.getAdExtension()).getScheduling().setDayTimeRanges(StringExtensions.parseDayTimeRanges(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtension, String>("Start Date", new Function<BulkAdExtension, String>(){

            @Override
            public String apply(BulkAdExtension t) {
                if (((AdExtension)t.getAdExtension()).getScheduling() == null) {
                    return null;
                }
                return StringExtensions.toScheduleDateBulkString(((AdExtension)t.getAdExtension()).getScheduling().getStartDate(), ((AdExtension)t.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                if (((AdExtension)c.getAdExtension()).getScheduling() == null) {
                    ((AdExtension)c.getAdExtension()).setScheduling(new Schedule());
                }
                try {
                    ((AdExtension)c.getAdExtension()).getScheduling().setStartDate(StringExtensions.parseDate(v));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtension, String>("End Date", new Function<BulkAdExtension, String>(){

            @Override
            public String apply(BulkAdExtension t) {
                if (((AdExtension)t.getAdExtension()).getScheduling() == null) {
                    return null;
                }
                return StringExtensions.toScheduleDateBulkString(((AdExtension)t.getAdExtension()).getScheduling().getEndDate(), ((AdExtension)t.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                if (((AdExtension)c.getAdExtension()).getScheduling() == null) {
                    ((AdExtension)c.getAdExtension()).setScheduling(new Schedule());
                }
                try {
                    ((AdExtension)c.getAdExtension()).getScheduling().setEndDate(StringExtensions.parseDate(v));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtension, String>("Use Searcher Time Zone", new Function<BulkAdExtension, String>(){

            @Override
            public String apply(BulkAdExtension t) {
                if (((AdExtension)t.getAdExtension()).getScheduling() == null) {
                    return null;
                }
                return StringExtensions.toUseSearcherTimeZoneBulkString(((AdExtension)t.getAdExtension()).getScheduling().getUseSearcherTimeZone());
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                if (((AdExtension)c.getAdExtension()).getScheduling() == null) {
                    ((AdExtension)c.getAdExtension()).setScheduling(new Schedule());
                }
                ((AdExtension)c.getAdExtension()).getScheduling().setUseSearcherTimeZone(StringExtensions.parseUseSearcherTimeZone(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkAdExtension, String>("Device Preference", new Function<BulkAdExtension, String>(){

            @Override
            public String apply(BulkAdExtension c) {
                return StringExtensions.toDevicePreferenceBulkString(((AdExtension)c.getAdExtension()).getDevicePreference());
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                ((AdExtension)c.getAdExtension()).setDevicePreference(StringExtensions.parseDevicePreference(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

