/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.WebpageConditionHelper;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupCriterion;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfWebpageCondition;
import com.microsoft.bingads.v12.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v12.campaignmanagement.Webpage;
import com.microsoft.bingads.v12.campaignmanagement.WebpageParameter;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupNegativeDynamicSearchAdTarget
extends SingleRecordBulkEntity {
    private NegativeAdGroupCriterion negativeAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeAdGroupCriterion adGroupCriterion = new NegativeAdGroupCriterion();
        Webpage webpage = new Webpage();
        webpage.setParameter(new WebpageParameter());
        adGroupCriterion.setCriterion(webpage);
        adGroupCriterion.getCriterion().setType(Webpage.class.getSimpleName());
        adGroupCriterion.setType("NegativeAdGroupCriterion");
        this.setNegativeAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeAdGroupCriterion(), AdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public NegativeAdGroupCriterion getNegativeAdGroupCriterion() {
        return this.negativeAdGroupCriterion;
    }

    public void setNegativeAdGroupCriterion(NegativeAdGroupCriterion negativeAdGroupCriterion) {
        this.negativeAdGroupCriterion = negativeAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, String>("Status", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                AdGroupCriterionStatus status = c.getNegativeAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                c.getNegativeAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, Long>("Id", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                return c.getNegativeAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                c.getNegativeAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, Long>("Parent Id", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                return c.getNegativeAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                c.getNegativeAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, String>("Campaign", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, String>("Ad Group", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new ComplexBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget>(new BiConsumer<BulkAdGroupNegativeDynamicSearchAdTarget, RowValues>(){

            @Override
            public void accept(BulkAdGroupNegativeDynamicSearchAdTarget c, RowValues v) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof Webpage) {
                    WebpageParameter webpageParameter = ((Webpage)c.getNegativeAdGroupCriterion().getCriterion()).getParameter();
                    if (webpageParameter == null || webpageParameter.getConditions() == null) {
                        return;
                    }
                    WebpageConditionHelper.addRowValuesFromConditions(webpageParameter.getConditions(), v);
                }
            }
        }, new BiConsumer<RowValues, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(RowValues v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                WebpageParameter webpageParameter;
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof Webpage && (webpageParameter = ((Webpage)c.getNegativeAdGroupCriterion().getCriterion()).getParameter()) != null) {
                    webpageParameter.setConditions(new ArrayOfWebpageCondition());
                    WebpageConditionHelper.addConditionsFromRowValues(v, webpageParameter.getConditions());
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, String>("Name", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof Webpage) {
                    WebpageParameter webpageParameter = ((Webpage)c.getNegativeAdGroupCriterion().getCriterion()).getParameter();
                    return StringExtensions.toCriterionNameBulkString(webpageParameter);
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                WebpageParameter webpageParameter;
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof Webpage && (webpageParameter = ((Webpage)c.getNegativeAdGroupCriterion().getCriterion()).getParameter()) != null) {
                    webpageParameter.setCriterionName(StringExtensions.parseCriterionName(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

