/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.internal.bulk;

import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.ServiceClient;
import com.microsoft.bingads.internal.OperationStatusRetry;
import com.microsoft.bingads.internal.ResultFuture;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.internal.functionalinterfaces.TriConsumer;
import com.microsoft.bingads.internal.utilities.ThreadPool;
import com.microsoft.bingads.v11.bulk.BulkOperationProgressInfo;
import com.microsoft.bingads.v11.bulk.BulkOperationStatus;
import com.microsoft.bingads.v11.bulk.CouldNotGetBulkOperationStatusException;
import com.microsoft.bingads.v11.bulk.IBulkService;
import com.microsoft.bingads.v11.bulk.Progress;
import com.microsoft.bingads.v11.internal.bulk.BulkOperationStatusProvider;
import com.microsoft.bingads.v11.internal.bulk.BulkOperationTracker;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class PollingBulkOperationTracker<TStatus>
implements BulkOperationTracker<TStatus> {
    private static final int INITIAL_STATUS_CHECK_INTERVAL_IN_MS = 1000;
    private static final int NUMBER_OF_INITIAL_STATUS_CHECKS = 5;
    private int numberOfStatusChecks = 0;
    private ScheduledExecutorService executorService;
    private BulkOperationStatusProvider<TStatus> statusProvider;
    private Progress<BulkOperationProgressInfo> progress;
    private boolean stopTracking;
    protected int lastProgressReported;
    private BulkOperationStatus<TStatus> currentStatus;
    private final int statusCheckIntervalInMs;
    private ResultFuture<BulkOperationStatus<TStatus>> trackResultFuture;
    private ServiceClient<IBulkService> serviceClient;
    private OperationStatusRetry<BulkOperationStatus<TStatus>, BulkOperationStatusProvider<TStatus>, IBulkService> operationStatusRetry;
    private int numberOfStatusRetry = 3;
    private final Runnable pollExecutorTask = new Runnable(){

        @Override
        public void run() {
            PollingBulkOperationTracker.this.pollOperationStatus();
        }
    };
    AtomicBoolean statusUpdateInProgress = new AtomicBoolean(false);

    public PollingBulkOperationTracker(BulkOperationStatusProvider<TStatus> statusProvider, ServiceClient<IBulkService> serviceClient, Progress<BulkOperationProgressInfo> progress, int statusCheckIntervalInMs) {
        this.statusCheckIntervalInMs = statusCheckIntervalInMs;
        this.statusProvider = statusProvider;
        this.serviceClient = serviceClient;
        this.progress = progress;
        this.operationStatusRetry = new OperationStatusRetry();
    }

    public void pollOperationStatus() {
        try {
            if (!this.statusUpdateInProgress.compareAndSet(false, true)) {
                return;
            }
            if (this.trackingWasStopped()) {
                return;
            }
            if (this.cancelPollingIfRequestedByUser()) {
                return;
            }
            this.refreshStatus(new AsyncCallback<BulkOperationStatus<TStatus>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted(Future<BulkOperationStatus<TStatus>> result) {
                    try {
                        result.get();
                        PollingBulkOperationTracker.this.numberOfStatusChecks++;
                        PollingBulkOperationTracker.this.reportProgressIfNeeded();
                        PollingBulkOperationTracker.this.completeTaskIfOperationIsComplete();
                    }
                    catch (InterruptedException ex) {
                        PollingBulkOperationTracker.this.stopTracking();
                        PollingBulkOperationTracker.this.propagateExceptionToCallingThread(new CouldNotGetBulkOperationStatusException(ex));
                    }
                    catch (ExecutionException ex) {
                        PollingBulkOperationTracker.this.stopTracking();
                        PollingBulkOperationTracker.this.propagateExceptionToCallingThread(new CouldNotGetBulkOperationStatusException(ex));
                    }
                    finally {
                        PollingBulkOperationTracker.this.statusUpdateInProgress.set(false);
                        if (!PollingBulkOperationTracker.this.stopTracking) {
                            int interval = 1000;
                            if (PollingBulkOperationTracker.this.numberOfStatusChecks >= 5) {
                                interval = PollingBulkOperationTracker.this.statusCheckIntervalInMs;
                            }
                            PollingBulkOperationTracker.this.executorService.schedule(PollingBulkOperationTracker.this.pollExecutorTask, (long)interval, TimeUnit.MILLISECONDS);
                        }
                    }
                }
            });
        }
        catch (Throwable ex) {
            this.stopTracking();
            this.propagateExceptionToCallingThread(ex);
        }
    }

    private boolean cancelPollingIfRequestedByUser() {
        if (this.trackResultFuture.isCancelled()) {
            this.stopTracking();
            return true;
        }
        return false;
    }

    private void reportProgressIfNeeded() {
        if (!this.userRequestedProgressReports()) {
            return;
        }
        if (this.progressChangedSinceLastReport()) {
            this.reportProgress();
        }
    }

    private void reportProgress() {
        final int percentage = this.currentStatus.getPercentComplete();
        ThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PollingBulkOperationTracker.this.progress.report(new BulkOperationProgressInfo(percentage));
                    PollingBulkOperationTracker.this.updateLastProgressReported(percentage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private boolean userRequestedProgressReports() {
        return this.progress != null;
    }

    private boolean progressChangedSinceLastReport() {
        return this.currentStatus.getPercentComplete() != this.lastProgressReported;
    }

    private void updateLastProgressReported(int per) {
        this.lastProgressReported = per;
    }

    private void propagateExceptionToCallingThread(Throwable ex) {
        this.trackResultFuture.setException(ex);
    }

    private void completeTaskIfOperationIsComplete() {
        if (this.operationIsComplete()) {
            this.stopTracking();
            this.completeTaskWithResult();
        }
    }

    private void completeTaskWithResult() {
        this.trackResultFuture.setResult(this.currentStatus);
    }

    private boolean operationIsComplete() {
        return this.statusProvider.isFinalStatus(this.currentStatus);
    }

    private void refreshStatus(AsyncCallback<BulkOperationStatus<TStatus>> callback) {
        final ResultFuture<BulkOperationStatus<TStatus>> resultFuture = new ResultFuture<BulkOperationStatus<TStatus>>(callback);
        this.operationStatusRetry.executeWithRetry(new TriConsumer<BulkOperationStatusProvider<TStatus>, ServiceClient<IBulkService>, AsyncCallback<BulkOperationStatus<TStatus>>>(){

            @Override
            public void accept(BulkOperationStatusProvider<TStatus> statusProvider, ServiceClient<IBulkService> serviceClient, AsyncCallback<BulkOperationStatus<TStatus>> callback) {
                statusProvider.getCurrentStatus(serviceClient, callback);
            }
        }, this.statusProvider, this.serviceClient, new Consumer<BulkOperationStatus<TStatus>>(){

            @Override
            public void accept(BulkOperationStatus<TStatus> status) {
                PollingBulkOperationTracker.this.currentStatus = status;
                resultFuture.setResult(PollingBulkOperationTracker.this.currentStatus);
            }
        }, new Consumer<Exception>(){

            @Override
            public void accept(Exception exception) {
                resultFuture.setException(exception);
            }
        }, this.numberOfStatusRetry);
    }

    private boolean trackingWasStopped() {
        return this.stopTracking;
    }

    private void stopTracking() {
        this.stopTracking = true;
        this.executorService.shutdown();
    }

    @Override
    public Future<BulkOperationStatus<TStatus>> trackResultFileAsync(AsyncCallback<BulkOperationStatus<TStatus>> callback) {
        this.trackResultFuture = new ResultFuture<BulkOperationStatus<TStatus>>(callback);
        this.startTracking();
        return this.trackResultFuture;
    }

    private void startTracking() {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.schedule(this.pollExecutorTask, 1000L, TimeUnit.MILLISECONDS);
    }
}

