/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.internal.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.internal.utilities.Comparer;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupNegativeSites;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.entities.BulkNegativeSiteIdentifier;
import com.microsoft.bingads.v11.internal.bulk.entities.MultiRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupNegativeSitesIdentifier
extends BulkNegativeSiteIdentifier {
    private String campaignName;
    private static List<BulkMapping<BulkAdGroupNegativeSitesIdentifier>> MAPPINGS;

    public long getAdGroupId() {
        return this.getEntityId();
    }

    public void setAdGroupId(long value) {
        this.setEntityId(value);
    }

    public String getAdGroupName() {
        return this.getEntityName();
    }

    public void setAdGroupName(String value) {
        this.setEntityName(value);
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    @Override
    public void readFromRowValues(RowValues values) {
        super.readFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void writeToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.writeToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public MultiRecordBulkEntity createEntityWithThisIdentifier() {
        return new BulkAdGroupNegativeSites(this);
    }

    @Override
    protected String getParentColumnName() {
        return "Ad Group";
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof BulkAdGroupNegativeSitesIdentifier)) {
            return false;
        }
        BulkAdGroupNegativeSitesIdentifier otherIdentifier = (BulkAdGroupNegativeSitesIdentifier)other;
        boolean isNameNotEmpty = this.getAdGroupName() != null && this.getAdGroupName().length() != 0 && this.getCampaignName() != null && this.getCampaignName().length() != 0;
        return Comparer.compareNullable(this.getAdGroupId(), otherIdentifier.getAdGroupId()) != false || isNameNotEmpty && Comparer.compareNullable(this.getAdGroupName(), otherIdentifier.getAdGroupName()) != false && Comparer.compareNullable(this.getCampaignName(), otherIdentifier.getCampaignName()) != false;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupNegativeSitesIdentifier, String>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupNegativeSitesIdentifier, String>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeSitesIdentifier, String>("Campaign", new Function<BulkAdGroupNegativeSitesIdentifier, String>(){

            @Override
            public String apply(BulkAdGroupNegativeSitesIdentifier c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeSitesIdentifier>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeSitesIdentifier c) {
                c.setCampaignName(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

