/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.Status;
import com.microsoft.bingads.v11.campaignmanagement.EntityScope;
import com.microsoft.bingads.v11.campaignmanagement.RemarketingList;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkRemarketingList
extends SingleRecordBulkEntity {
    private RemarketingList remarketingList;
    private Status status;
    private static final List<BulkMapping<BulkRemarketingList>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setRemarketingList(new RemarketingList());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getRemarketingList(), "RemarketingList");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public RemarketingList getRemarketingList() {
        return this.remarketingList;
    }

    public void setRemarketingList(RemarketingList remarketingList) {
        this.remarketingList = remarketingList;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkRemarketingList, Object>> m = new ArrayList<SimpleBulkMapping<BulkRemarketingList, Object>>();
        m.add(new SimpleBulkMapping<BulkRemarketingList, String>("Status", new Function<BulkRemarketingList, String>(){

            @Override
            public String apply(BulkRemarketingList c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRemarketingList, Long>("Id", new Function<BulkRemarketingList, Long>(){

            @Override
            public Long apply(BulkRemarketingList c) {
                return c.getRemarketingList().getId();
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.getRemarketingList().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRemarketingList, Long>("Parent Id", new Function<BulkRemarketingList, Long>(){

            @Override
            public Long apply(BulkRemarketingList c) {
                return c.getRemarketingList().getParentId();
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.getRemarketingList().setParentId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRemarketingList, String>("Audience", new Function<BulkRemarketingList, String>(){

            @Override
            public String apply(BulkRemarketingList c) {
                return c.getRemarketingList().getName();
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.getRemarketingList().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkRemarketingList, String>("Description", new Function<BulkRemarketingList, String>(){

            @Override
            public String apply(BulkRemarketingList c) {
                return c.getRemarketingList().getDescription();
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.getRemarketingList().setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkRemarketingList, Integer>("Membership Duration", new Function<BulkRemarketingList, Integer>(){

            @Override
            public Integer apply(BulkRemarketingList c) {
                return c.getRemarketingList().getMembershipDuration();
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.getRemarketingList().setMembershipDuration(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRemarketingList, String>("Scope", new Function<BulkRemarketingList, String>(){

            @Override
            public String apply(BulkRemarketingList c) {
                return c.getRemarketingList().getScope() != null ? c.getRemarketingList().getScope().value() : null;
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.getRemarketingList().setScope(StringExtensions.parseOptional(v, new Function<String, EntityScope>(){

                    @Override
                    public EntityScope apply(String value) {
                        return EntityScope.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRemarketingList, Long>("UET Tag Id", new Function<BulkRemarketingList, Long>(){

            @Override
            public Long apply(BulkRemarketingList c) {
                return c.getRemarketingList().getTagId();
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.getRemarketingList().setTagId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRemarketingList, String>("Remarketing Rule", new Function<BulkRemarketingList, String>(){

            @Override
            public String apply(BulkRemarketingList c) {
                return StringExtensions.toRemarketingRuleBulkString(c.getRemarketingList().getRule());
            }
        }, new BiConsumer<String, BulkRemarketingList>(){

            @Override
            public void accept(String v, BulkRemarketingList c) {
                c.getRemarketingList().setRule(StringExtensions.parseRemarketingRule(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

