/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.Predicate;
import com.microsoft.bingads.v10.bulk.entities.BulkEntity;
import com.microsoft.bingads.v10.bulk.entities.BulkSiteLink;
import com.microsoft.bingads.v10.campaignmanagement.AdExtensionStatus;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfSiteLink;
import com.microsoft.bingads.v10.campaignmanagement.SiteLink;
import com.microsoft.bingads.v10.campaignmanagement.SiteLinksAdExtension;
import com.microsoft.bingads.v10.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.v10.internal.bulk.BulkStreamReader;
import com.microsoft.bingads.v10.internal.bulk.TryResult;
import com.microsoft.bingads.v10.internal.bulk.entities.MultiRecordBulkEntity;
import com.microsoft.bingads.v10.internal.bulk.entities.SiteLinkAdExtensionIdentifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BulkSiteLinkAdExtension
extends MultiRecordBulkEntity {
    private Long accountId;
    private SiteLinksAdExtension siteLinksAdExtension;
    private final List<BulkSiteLink> bulkSiteLinkResults = new ArrayList<BulkSiteLink>();
    private SiteLinkAdExtensionIdentifier identifier;
    private boolean hasDeleteAllRow;
    static final Comparator<BulkSiteLink> ORDER_BY_ORDER = new Comparator<BulkSiteLink>(){

        @Override
        public int compare(BulkSiteLink o1, BulkSiteLink o2) {
            return Integer.valueOf(o1.getOrder()).compareTo(o2.getOrder());
        }
    };

    public List<BulkSiteLink> getSiteLinks() {
        return Collections.unmodifiableList(this.bulkSiteLinkResults);
    }

    @Override
    public List<? extends BulkEntity> getChildEntities() {
        return Collections.unmodifiableList(this.bulkSiteLinkResults);
    }

    public BulkSiteLinkAdExtension() {
    }

    public BulkSiteLinkAdExtension(SiteLinkAdExtensionIdentifier identifier) {
        this();
        this.identifier = identifier;
        this.hasDeleteAllRow = AdExtensionStatus.DELETED.equals((Object)identifier.getStatus());
        this.siteLinksAdExtension = new SiteLinksAdExtension();
        this.siteLinksAdExtension.setType("SiteLinksAdExtension");
        this.siteLinksAdExtension.setId(identifier.getAdExtensionId());
        this.siteLinksAdExtension.setStatus(identifier.getStatus());
        this.siteLinksAdExtension.setVersion(identifier.getVersion());
        this.accountId = identifier.getAccountId();
    }

    BulkSiteLinkAdExtension(BulkSiteLink firstSiteLink) {
        this(firstSiteLink.getIdentifier());
        this.bulkSiteLinkResults.add(firstSiteLink);
    }

    @Override
    public void writeToStream(BulkObjectWriter rowWriter, boolean excludeReadonlyData) throws IOException {
        this.validatePropertyNotNull(this.siteLinksAdExtension, "SiteLinksAdExtension");
        this.validatePropertyNotNull(this.siteLinksAdExtension.getId(), "SiteLinksAdExtension.getId()");
        if (!AdExtensionStatus.DELETED.equals((Object)this.siteLinksAdExtension.getStatus())) {
            this.validateListNotNullOrEmpty(this.siteLinksAdExtension.getSiteLinks(), this.siteLinksAdExtension.getSiteLinks().getSiteLinks(), "SiteLinksAdExtension.SiteLinks");
        }
        SiteLinkAdExtensionIdentifier identifier = new SiteLinkAdExtensionIdentifier();
        identifier.setStatus(AdExtensionStatus.DELETED);
        identifier.setAccountId(this.accountId);
        identifier.setAdExtensionId(this.siteLinksAdExtension.getId());
        rowWriter.writeObjectRow(identifier, excludeReadonlyData);
        if (AdExtensionStatus.DELETED.equals((Object)this.siteLinksAdExtension.getStatus())) {
            return;
        }
        for (BulkSiteLink bulkSiteLink : this.convertV9ToBulkSiteLinks()) {
            bulkSiteLink.writeToStream(rowWriter, excludeReadonlyData);
        }
    }

    private List<BulkSiteLink> convertV9ToBulkSiteLinks() {
        int order = 1;
        List<SiteLink> siteLinks = this.siteLinksAdExtension.getSiteLinks().getSiteLinks();
        ArrayList<BulkSiteLink> bulkSiteLinks = new ArrayList<BulkSiteLink>();
        for (SiteLink siteLink : siteLinks) {
            BulkSiteLink bulkSiteLink = new BulkSiteLink();
            bulkSiteLink.setSiteLink(siteLink);
            bulkSiteLink.setAccountId(this.accountId);
            bulkSiteLink.setAdExtensionId(this.siteLinksAdExtension.getId());
            bulkSiteLink.setOrder(order++);
            bulkSiteLinks.add(bulkSiteLink);
        }
        return bulkSiteLinks;
    }

    @Override
    public void readRelatedDataFromStream(BulkStreamReader reader) {
        boolean hasMoreRows = true;
        while (hasMoreRows) {
            TryResult<BulkSiteLink> nextSiteLinkResult = reader.tryRead(new Predicate<BulkSiteLink>(){

                @Override
                public boolean test(BulkSiteLink x) {
                    return x.getIdentifier().equals(BulkSiteLinkAdExtension.this.identifier);
                }
            }, BulkSiteLink.class);
            if (nextSiteLinkResult.isSuccessful()) {
                this.bulkSiteLinkResults.add(nextSiteLinkResult.getResult());
                continue;
            }
            TryResult<SiteLinkAdExtensionIdentifier> identifierResult = reader.tryRead(new Predicate<SiteLinkAdExtensionIdentifier>(){

                @Override
                public boolean test(SiteLinkAdExtensionIdentifier x) {
                    return x.equals(BulkSiteLinkAdExtension.this.identifier);
                }
            }, SiteLinkAdExtensionIdentifier.class);
            if (identifierResult.isSuccessful()) {
                if (!AdExtensionStatus.DELETED.equals((Object)identifierResult.getResult().getStatus())) continue;
                this.hasDeleteAllRow = true;
                continue;
            }
            hasMoreRows = false;
        }
        if (this.bulkSiteLinkResults.size() > 0) {
            this.siteLinksAdExtension.setSiteLinks(this.getSortedSiteLinks());
            this.siteLinksAdExtension.setStatus(AdExtensionStatus.ACTIVE);
        } else {
            this.siteLinksAdExtension.setStatus(AdExtensionStatus.DELETED);
        }
    }

    private ArrayOfSiteLink getSortedSiteLinks() {
        ArrayList<BulkSiteLink> sortedBulkSiteLinks = new ArrayList<BulkSiteLink>(this.bulkSiteLinkResults);
        Collections.sort(sortedBulkSiteLinks, ORDER_BY_ORDER);
        ArrayOfSiteLink apiSiteLinks = new ArrayOfSiteLink();
        for (BulkSiteLink bulkSiteLink : sortedBulkSiteLinks) {
            apiSiteLinks.getSiteLinks().add(bulkSiteLink.getSiteLink());
        }
        return apiSiteLinks;
    }

    @Override
    public boolean allChildrenPresent() {
        return this.hasDeleteAllRow;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public SiteLinksAdExtension getSiteLinksAdExtension() {
        return this.siteLinksAdExtension;
    }

    public void setSiteLinksAdExtension(SiteLinksAdExtension siteLinksAdExtension) {
        this.siteLinksAdExtension = siteLinksAdExtension;
    }
}

