/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.bulk.entities.WebpageConditionHelper;
import com.microsoft.bingads.v10.campaignmanagement.AdGroupCriterion;
import com.microsoft.bingads.v10.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfWebpageCondition;
import com.microsoft.bingads.v10.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v10.campaignmanagement.Webpage;
import com.microsoft.bingads.v10.campaignmanagement.WebpageParameter;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import com.microsoft.bingads.v10.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupNegativeDynamicSearchAdTarget
extends SingleRecordBulkEntity {
    private AdGroupCriterion adGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeAdGroupCriterion adGroupCriterion = new NegativeAdGroupCriterion();
        Webpage webpage = new Webpage();
        webpage.setParameter(new WebpageParameter());
        adGroupCriterion.setCriterion(webpage);
        adGroupCriterion.getCriterion().setType(Webpage.class.getSimpleName());
        adGroupCriterion.setType("NegativeAdGroupCriterion");
        this.setAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroupCriterion(), AdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public AdGroupCriterion getAdGroupCriterion() {
        return this.adGroupCriterion;
    }

    public void setAdGroupCriterion(AdGroupCriterion adGroupCriterion) {
        this.adGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, String>("Status", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                AdGroupCriterionStatus status = c.getAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                c.getAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, Long>("Id", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                return c.getAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                c.getAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, Long>("Parent Id", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                return c.getAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                c.getAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, String>("Campaign", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, String>("Ad Group", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new ComplexBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget>(new BiConsumer<BulkAdGroupNegativeDynamicSearchAdTarget, RowValues>(){

            @Override
            public void accept(BulkAdGroupNegativeDynamicSearchAdTarget c, RowValues v) {
                if (c.getAdGroupCriterion().getCriterion() instanceof Webpage) {
                    WebpageParameter webpageParameter = ((Webpage)c.getAdGroupCriterion().getCriterion()).getParameter();
                    if (webpageParameter == null || webpageParameter.getConditions() == null) {
                        return;
                    }
                    WebpageConditionHelper.addRowValuesFromConditions(webpageParameter.getConditions(), v);
                }
            }
        }, new BiConsumer<RowValues, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(RowValues v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                WebpageParameter webpageParameter;
                if (c.getAdGroupCriterion().getCriterion() instanceof Webpage && (webpageParameter = ((Webpage)c.getAdGroupCriterion().getCriterion()).getParameter()) != null) {
                    webpageParameter.setConditions(new ArrayOfWebpageCondition());
                    WebpageConditionHelper.addConditionsFromRowValues(v, webpageParameter.getConditions());
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeDynamicSearchAdTarget, String>("Name", new Function<BulkAdGroupNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupNegativeDynamicSearchAdTarget c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof Webpage) {
                    WebpageParameter webpageParameter = ((Webpage)c.getAdGroupCriterion().getCriterion()).getParameter();
                    return StringExtensions.toCriterionNameBulkString(webpageParameter);
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeDynamicSearchAdTarget c) {
                WebpageParameter webpageParameter;
                if (c.getAdGroupCriterion().getCriterion() instanceof Webpage && (webpageParameter = ((Webpage)c.getAdGroupCriterion().getCriterion()).getParameter()) != null) {
                    webpageParameter.setCriterionName(StringExtensions.parseCriterionName(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

