/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.bulk.entities.PerformanceData;
import com.microsoft.bingads.v10.bulk.entities.WebpageConditionHelper;
import com.microsoft.bingads.v10.campaignmanagement.AdGroupCriterion;
import com.microsoft.bingads.v10.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfWebpageCondition;
import com.microsoft.bingads.v10.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v10.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v10.campaignmanagement.FixedBid;
import com.microsoft.bingads.v10.campaignmanagement.Webpage;
import com.microsoft.bingads.v10.campaignmanagement.WebpageParameter;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import com.microsoft.bingads.v10.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupDynamicSearchAdTarget
extends SingleRecordBulkEntity {
    private AdGroupCriterion adGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAdGroupDynamicSearchAdTarget>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        FixedBid fixedBid = new FixedBid();
        fixedBid.setType(FixedBid.class.getSimpleName());
        Webpage webpage = new Webpage();
        webpage.setParameter(new WebpageParameter());
        adGroupCriterion.setCriterion(webpage);
        adGroupCriterion.getCriterion().setType(Webpage.class.getSimpleName());
        adGroupCriterion.setCriterionBid(fixedBid);
        adGroupCriterion.setType("BiddableAdGroupCriterion");
        this.setAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroupCriterion(), AdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.getPerformanceData(), values);
        }
    }

    public AdGroupCriterion getAdGroupCriterion() {
        return this.adGroupCriterion;
    }

    public void setAdGroupCriterion(AdGroupCriterion adGroupCriterion) {
        this.adGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Status", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                AdGroupCriterionStatus status = c.getAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                c.getAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, Long>("Id", new Function<BulkAdGroupDynamicSearchAdTarget, Long>(){

            @Override
            public Long apply(BulkAdGroupDynamicSearchAdTarget c) {
                return c.getAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                c.getAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, Long>("Parent Id", new Function<BulkAdGroupDynamicSearchAdTarget, Long>(){

            @Override
            public Long apply(BulkAdGroupDynamicSearchAdTarget c) {
                return c.getAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                c.getAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Campaign", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Ad Group", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Bid", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toAdGroupCriterionBidBulkString(((FixedBid)bid).getBid());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((FixedBid)((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getCriterionBid()).setBid(StringExtensions.parseAdGroupCriterionBid(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Tracking Template", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toOptionalBulkString(((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getTrackingUrlTemplate());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Custom Parameter", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toCustomParaBulkString(((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getUrlCustomParameters());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    try {
                        ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        m.add(new ComplexBulkMapping<BulkAdGroupDynamicSearchAdTarget>(new BiConsumer<BulkAdGroupDynamicSearchAdTarget, RowValues>(){

            @Override
            public void accept(BulkAdGroupDynamicSearchAdTarget c, RowValues v) {
                if (c.getAdGroupCriterion().getCriterion() instanceof Webpage) {
                    WebpageParameter webpageParameter = ((Webpage)c.getAdGroupCriterion().getCriterion()).getParameter();
                    if (webpageParameter == null || webpageParameter.getConditions() == null) {
                        return;
                    }
                    WebpageConditionHelper.addRowValuesFromConditions(webpageParameter.getConditions(), v);
                }
            }
        }, new BiConsumer<RowValues, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(RowValues v, BulkAdGroupDynamicSearchAdTarget c) {
                WebpageParameter webpageParameter;
                if (c.getAdGroupCriterion().getCriterion() instanceof Webpage && (webpageParameter = ((Webpage)c.getAdGroupCriterion().getCriterion()).getParameter()) != null) {
                    webpageParameter.setConditions(new ArrayOfWebpageCondition());
                    WebpageConditionHelper.addConditionsFromRowValues(v, webpageParameter.getConditions());
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDynamicSearchAdTarget, String>("Name", new Function<BulkAdGroupDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkAdGroupDynamicSearchAdTarget c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof Webpage) {
                    WebpageParameter webpageParameter = ((Webpage)c.getAdGroupCriterion().getCriterion()).getParameter();
                    return StringExtensions.toCriterionNameBulkString(webpageParameter);
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkAdGroupDynamicSearchAdTarget c) {
                WebpageParameter webpageParameter;
                if (c.getAdGroupCriterion().getCriterion() instanceof Webpage && (webpageParameter = ((Webpage)c.getAdGroupCriterion().getCriterion()).getParameter()) != null) {
                    webpageParameter.setCriterionName(StringExtensions.parseCriterionName(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

