/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.internal.reporting;

import com.microsoft.bingads.v12.internal.reporting.CsvReportRecordReader;
import com.microsoft.bingads.v12.reporting.ReportFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class RowReportRecordReaderFactory {
    RowReportRecordReaderFactory() {
    }

    static CsvReportRecordReader createReportRecordReader(String filePath, ReportFormat format) throws IOException {
        switch (format) {
            case CSV: {
                return new CsvReportRecordReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8")), ',');
            }
            case TSV: {
                return new CsvReportRecordReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8")), '\t');
            }
        }
        return null;
    }

    static CsvReportRecordReader createReportRecordReader(File file, ReportFormat format) throws IOException {
        switch (format) {
            case CSV: {
                return new CsvReportRecordReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8")), ',');
            }
            case TSV: {
                return new CsvReportRecordReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8")), '\t');
            }
        }
        return null;
    }
}

