/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.PerformanceData;
import com.microsoft.bingads.v12.bulk.entities.QualityScoreData;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfSetting;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v12.campaignmanagement.Bid;
import com.microsoft.bingads.v12.campaignmanagement.BiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.BudgetLimitType;
import com.microsoft.bingads.v12.campaignmanagement.Campaign;
import com.microsoft.bingads.v12.campaignmanagement.CampaignStatus;
import com.microsoft.bingads.v12.campaignmanagement.CampaignType;
import com.microsoft.bingads.v12.campaignmanagement.DynamicSearchAdsSetting;
import com.microsoft.bingads.v12.campaignmanagement.DynamicSearchAdsSource;
import com.microsoft.bingads.v12.campaignmanagement.MaxClicksBiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.MaxConversionsBiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.Setting;
import com.microsoft.bingads.v12.campaignmanagement.ShoppingSetting;
import com.microsoft.bingads.v12.campaignmanagement.TargetCpaBiddingScheme;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class BulkCampaign
extends SingleRecordBulkEntity {
    private Long accountId;
    private Campaign campaign;
    private QualityScoreData qualityScoreData;
    private PerformanceData performanceData;
    private String budgetName;
    private static final List<BulkMapping<BulkCampaign>> MAPPINGS;
    private static BiConsumer<BulkCampaign, RowValues> budgetToCsv;
    private static BiConsumer<RowValues, BulkCampaign> csvToBudget;

    private Setting getCampaignSetting(Class<? extends Setting> settingClass, boolean addIfNotExist) {
        if (this.campaign.getSettings() == null && addIfNotExist) {
            this.tryAddCampaignSettings();
        }
        if (this.getCampaign().getSettings() == null) {
            return null;
        }
        List settings = this.getCampaign().getSettings().getSettings().stream().filter(s -> s.getClass() == settingClass).collect(Collectors.toList());
        if (settings.isEmpty()) {
            return null;
        }
        if (settings.size() != 1) {
            throw new IllegalArgumentException(String.format("Can only have 1 %s in Campaign Settings.", settingClass.getSimpleName()));
        }
        return (Setting)settings.get(0);
    }

    private void tryAddCampaignSettings() {
        Collection<CampaignType> campaignTypes = this.campaign.getCampaignType();
        if (campaignTypes.isEmpty()) {
            return;
        }
        if (campaignTypes.size() > 1) {
            throw new IllegalArgumentException("Can only have 1 campaign type in Campaign types.");
        }
        for (CampaignType type : campaignTypes) {
            this.addCampaignSettings(type);
        }
    }

    private void addCampaignSettings(CampaignType campaignType) {
        ArrayOfSetting arrayOfSettings = new ArrayOfSetting();
        Setting setting = null;
        switch (campaignType) {
            case SEARCH: {
                break;
            }
            case SHOPPING: 
            case AUDIENCE: {
                setting = new ShoppingSetting();
                setting.setType(ShoppingSetting.class.getSimpleName());
                break;
            }
            case DYNAMIC_SEARCH_ADS: {
                setting = new DynamicSearchAdsSetting();
                setting.setType(DynamicSearchAdsSetting.class.getSimpleName());
            }
        }
        if (setting != null) {
            arrayOfSettings.getSettings().add(setting);
            this.campaign.setSettings(arrayOfSettings);
        }
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public void setCampaign(Campaign campaign) {
        this.campaign = campaign;
    }

    public QualityScoreData getQualityScoreData() {
        return this.qualityScoreData;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    public String getBudgetName() {
        return this.budgetName;
    }

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setCampaign(new Campaign());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.qualityScoreData = QualityScoreData.readFromRowValuesOrNull(values);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCampaign(), "Campaign");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            QualityScoreData.writeToRowValuesIfNotNull(this.qualityScoreData, values);
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public static boolean isDailyBudget(BudgetLimitType budgetType) {
        return BudgetLimitType.DAILY_BUDGET_ACCELERATED.equals((Object)budgetType) || BudgetLimitType.DAILY_BUDGET_STANDARD.equals((Object)budgetType);
    }

    static {
        budgetToCsv = new BiConsumer<BulkCampaign, RowValues>(){

            @Override
            public void accept(BulkCampaign c, RowValues values) {
                BudgetLimitType budgetType = c.getCampaign().getBudgetType();
                if (budgetType == null) {
                    return;
                }
                Double budget = null;
                if (BulkCampaign.isDailyBudget(budgetType)) {
                    budget = c.getCampaign().getDailyBudget();
                }
                if (budget == null) {
                    return;
                }
                values.put("Budget", budget.toString());
            }
        };
        csvToBudget = new BiConsumer<RowValues, BulkCampaign>(){

            @Override
            public void accept(RowValues values, BulkCampaign c) {
                String budgetTypeRowValue = values.get("Budget Type");
                BudgetLimitType budgetType = StringExtensions.parseOptional(budgetTypeRowValue, new Function<String, BudgetLimitType>(){

                    @Override
                    public BudgetLimitType apply(String value) {
                        return BudgetLimitType.fromValue(value);
                    }
                });
                if (budgetType == null) {
                    return;
                }
                String budgetRowValue = values.get("Budget");
                if (budgetRowValue == null) {
                    return;
                }
                Double budgetValue = StringExtensions.nullOrDouble(budgetRowValue);
                c.getCampaign().setBudgetType(budgetType);
                if (BulkCampaign.isDailyBudget(budgetType)) {
                    c.getCampaign().setDailyBudget(budgetValue);
                }
            }
        };
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Campaign Type", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                if (c.getCampaign().getCampaignType().size() != 1) {
                    throw new IllegalArgumentException("Only 1 CampaignType can be set in Campaign");
                }
                Collection<CampaignType> campaignTypes = c.getCampaign().getCampaignType();
                return campaignTypes.toArray(new CampaignType[campaignTypes.size()])[0].value();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                CampaignType campaignType = StringExtensions.parseOptional(v, new Function<String, CampaignType>(){

                    @Override
                    public CampaignType apply(String value) {
                        return CampaignType.fromValue(value);
                    }
                });
                if (campaignType != null) {
                    c.getCampaign().setCampaignType(Collections.singleton(campaignType));
                    c.addCampaignSettings(campaignType);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                return c.getCampaign().getId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Status", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getStatus() != null ? c.getCampaign().getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignStatus>(){

                    @Override
                    public CampaignStatus apply(String value) {
                        return CampaignStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Parent Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setAccountId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Campaign", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getName();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Time Zone", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getTimeZone();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setTimeZone(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Language", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return StringExtensions.writeCampaignLanguages(";", c.getCampaign().getLanguages());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                ArrayOfstring languages = new ArrayOfstring();
                List<String> languageArray = StringExtensions.parseCampaignLanguages(v);
                if (languageArray == null) {
                    languages = null;
                } else {
                    languages.getStrings().addAll(languageArray);
                }
                c.getCampaign().setLanguages(languages);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Budget Type", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getBudgetType() != null ? c.getCampaign().getBudgetType().value() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setBudgetType(StringExtensions.parseOptional(v, new Function<String, BudgetLimitType>(){

                    @Override
                    public BudgetLimitType apply(String value) {
                        return BudgetLimitType.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Budget Id", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getBudgetId() != null ? c.getCampaign().getBudgetId().toString() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setBudgetId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Budget Name", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getBudgetName();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setBudgetName(v);
            }
        }));
        m.add(new ComplexBulkMapping<BulkCampaign>(budgetToCsv, csvToBudget));
        m.add(new SimpleBulkMapping<BulkCampaign, Integer>("Bid Adjustment", new Function<BulkCampaign, Integer>(){

            @Override
            public Integer apply(BulkCampaign c) {
                return c.getCampaign().getAudienceAdsBidAdjustment();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setAudienceAdsBidAdjustment(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Store Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, false);
                return setting == null ? null : ((ShoppingSetting)setting).getStoreId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((ShoppingSetting)setting).setStoreId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Integer>("Priority", new Function<BulkCampaign, Integer>(){

            @Override
            public Integer apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, false);
                return setting == null ? null : ((ShoppingSetting)setting).getPriority();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((ShoppingSetting)setting).setPriority(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String s) {
                        return Integer.parseInt(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Country Code", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, false);
                return setting == null ? null : ((ShoppingSetting)setting).getSalesCountryCode();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((ShoppingSetting)setting).setSalesCountryCode(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("LocalInventoryAdsEnabled", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return StringExtensions.toBooleanBulkString(((ShoppingSetting)setting).getLocalInventoryAdsEnabled());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((ShoppingSetting)setting).setLocalInventoryAdsEnabled(StringExtensions.parseOptional(v, new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String value) {
                        return Boolean.parseBoolean(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Tracking Template", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return StringExtensions.toOptionalBulkString(c.getCampaign().getTrackingUrlTemplate());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Custom Parameter", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return StringExtensions.toCustomParaBulkString(c.getCampaign().getUrlCustomParameters());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                try {
                    c.getCampaign().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new ComplexBulkMapping<BulkCampaign>(new BiConsumer<BulkCampaign, RowValues>(){

            @Override
            public void accept(BulkCampaign c, RowValues values) {
                try {
                    BiddingScheme biddingScheme = c.getCampaign().getBiddingScheme();
                    if (biddingScheme == null) {
                        return;
                    }
                    values.put("Bid Strategy Type", StringExtensions.toBiddingSchemeBulkString(biddingScheme));
                    if (c.getCampaign().getBiddingScheme() instanceof MaxClicksBiddingScheme) {
                        Bid maxCpc = ((MaxClicksBiddingScheme)c.getCampaign().getBiddingScheme()).getMaxCpc();
                        values.put("Bid Strategy MaxCpc", StringExtensions.toBidBulkString(maxCpc));
                    } else if (c.getCampaign().getBiddingScheme() instanceof MaxConversionsBiddingScheme) {
                        Bid maxCpc = ((MaxConversionsBiddingScheme)c.getCampaign().getBiddingScheme()).getMaxCpc();
                        values.put("Bid Strategy MaxCpc", StringExtensions.toBidBulkString(maxCpc));
                    } else if (c.getCampaign().getBiddingScheme() instanceof TargetCpaBiddingScheme) {
                        Bid maxCpc = ((TargetCpaBiddingScheme)c.getCampaign().getBiddingScheme()).getMaxCpc();
                        values.put("Bid Strategy MaxCpc", StringExtensions.toBidBulkString(maxCpc));
                        Double targetCpa = ((TargetCpaBiddingScheme)c.getCampaign().getBiddingScheme()).getTargetCpa();
                        if (targetCpa != null) {
                            values.put("Bid Strategy TargetCpa", targetCpa.toString());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, new BiConsumer<RowValues, BulkCampaign>(){

            @Override
            public void accept(RowValues values, BulkCampaign c) {
                try {
                    String bidStrategyTypeRowValue = values.get("Bid Strategy Type");
                    BiddingScheme biddingScheme = StringExtensions.parseBiddingScheme(bidStrategyTypeRowValue);
                    if (biddingScheme == null) {
                        return;
                    }
                    String maxCpcRowValue = values.get("Bid Strategy MaxCpc");
                    String targetCpaRowValue = values.get("Bid Strategy TargetCpa");
                    Bid maxCpcValue = StringExtensions.parseBid(maxCpcRowValue);
                    Double targetCpaValue = StringExtensions.nullOrDouble(targetCpaRowValue);
                    if (biddingScheme instanceof MaxClicksBiddingScheme) {
                        ((MaxClicksBiddingScheme)biddingScheme).setMaxCpc(maxCpcValue);
                    } else if (biddingScheme instanceof MaxConversionsBiddingScheme) {
                        ((MaxConversionsBiddingScheme)biddingScheme).setMaxCpc(maxCpcValue);
                    } else if (biddingScheme instanceof TargetCpaBiddingScheme) {
                        ((TargetCpaBiddingScheme)biddingScheme).setMaxCpc(maxCpcValue);
                        ((TargetCpaBiddingScheme)biddingScheme).setTargetCpa(targetCpaValue);
                    }
                    c.getCampaign().setBiddingScheme(biddingScheme);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Website", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return ((DynamicSearchAdsSetting)setting).getDomainName();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((DynamicSearchAdsSetting)setting).setDomainName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Domain Language", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return ((DynamicSearchAdsSetting)setting).getLanguage();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((DynamicSearchAdsSetting)setting).setLanguage(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Source", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, false);
                if (setting == null) {
                    return null;
                }
                DynamicSearchAdsSetting dsaSetting = (DynamicSearchAdsSetting)setting;
                if (dsaSetting.getSource() == null) {
                    return null;
                }
                return dsaSetting.getSource().value();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((DynamicSearchAdsSetting)setting).setSource(StringExtensions.parseOptional(v, new Function<String, DynamicSearchAdsSource>(){

                    @Override
                    public DynamicSearchAdsSource apply(String value) {
                        return DynamicSearchAdsSource.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Sub Type", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getSubType();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setSubType(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

