/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.PerformanceData;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v11.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v11.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v11.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupRemarketingListAssociation
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private String remarketingListName;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAdGroupRemarketingListAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        adGroupCriterion.setType(BiddableAdGroupCriterion.class.getSimpleName());
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        AudienceCriterion audienceCriterion = new AudienceCriterion();
        audienceCriterion.setType(AudienceCriterion.class.getSimpleName());
        adGroupCriterion.setCriterion(audienceCriterion);
        adGroupCriterion.setCriterionBid(bidMultiplier);
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), "AdGroupRemarketingListAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion adGroupCriterion) {
        this.biddableAdGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getRemarketingListName() {
        return this.remarketingListName;
    }

    public void setRemarketingListName(String remarketingListName) {
        this.remarketingListName = remarketingListName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, String>("Status", new Function<BulkAdGroupRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupRemarketingListAssociation c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Long>("Id", new Function<BulkAdGroupRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Long>("Parent Id", new Function<BulkAdGroupRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, String>("Campaign", new Function<BulkAdGroupRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, String>("Ad Group", new Function<BulkAdGroupRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, String>("Audience", new Function<BulkAdGroupRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupRemarketingListAssociation c) {
                return c.getRemarketingListName();
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                c.setRemarketingListName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, String>("Bid Adjustment", new Function<BulkAdGroupRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupRemarketingListAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getBiddableAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getBiddableAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupRemarketingListAssociation, Long>("Audience Id", new Function<BulkAdGroupRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupRemarketingListAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupRemarketingListAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

