/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.Supplier;
import com.microsoft.bingads.v12.bulk.entities.BulkAccount;
import com.microsoft.bingads.v12.bulk.entities.BulkAccountAppAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAccountCalloutAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAccountImageAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAccountLocationAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAccountPriceAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAccountReviewAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAccountSitelinkAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAccountStructuredSnippetAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroup;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupAgeCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupAppAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupCalloutAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupCompanyNameCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupCustomAudienceAssociation;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupDayTimeCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupDeviceCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupDynamicSearchAdTarget;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupGenderCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupImageAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupInMarketAudienceAssociation;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupIndustryCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupJobFunctionCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupLabel;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupLocationCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupLocationIntentCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeAgeCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeCompanyNameCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeCustomAudienceAssociation;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeDynamicSearchAdTarget;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeGenderCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeInMarketAudienceAssociation;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeIndustryCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeJobFunctionCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeKeyword;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeLocationCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeProductAudienceAssociation;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeRemarketingListAssociation;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupNegativeSite;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupPriceAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupProductAudienceAssociation;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupProductPartition;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupRadiusCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupRemarketingListAssociation;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupReviewAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupSitelinkAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAdGroupStructuredSnippetAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAppAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkAppInstallAd;
import com.microsoft.bingads.v12.bulk.entities.BulkAppInstallAdLabel;
import com.microsoft.bingads.v12.bulk.entities.BulkBudget;
import com.microsoft.bingads.v12.bulk.entities.BulkCallAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCalloutAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaign;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignAgeCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignAppAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignCallAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignCalloutAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignCompanyNameCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignDayTimeCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignDeviceCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignGenderCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignImageAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignIndustryCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignJobFunctionCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignLabel;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignLocationAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignLocationCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignLocationIntentCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignNegativeDynamicSearchAdTarget;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignNegativeKeyword;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignNegativeKeywordList;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignNegativeLocationCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignNegativeSite;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignPriceAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignProductScope;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignRadiusCriterion;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignReviewAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignSitelinkAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCampaignStructuredSnippetAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkCustomAudience;
import com.microsoft.bingads.v12.bulk.entities.BulkDynamicSearchAd;
import com.microsoft.bingads.v12.bulk.entities.BulkDynamicSearchAdLabel;
import com.microsoft.bingads.v12.bulk.entities.BulkError;
import com.microsoft.bingads.v12.bulk.entities.BulkExpandedTextAd;
import com.microsoft.bingads.v12.bulk.entities.BulkExpandedTextAdLabel;
import com.microsoft.bingads.v12.bulk.entities.BulkImageAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkInMarketAudience;
import com.microsoft.bingads.v12.bulk.entities.BulkKeyword;
import com.microsoft.bingads.v12.bulk.entities.BulkKeywordBestPositionBid;
import com.microsoft.bingads.v12.bulk.entities.BulkKeywordFirstPageBid;
import com.microsoft.bingads.v12.bulk.entities.BulkKeywordLabel;
import com.microsoft.bingads.v12.bulk.entities.BulkKeywordMainLineBid;
import com.microsoft.bingads.v12.bulk.entities.BulkLabel;
import com.microsoft.bingads.v12.bulk.entities.BulkLocationAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkNegativeKeywordList;
import com.microsoft.bingads.v12.bulk.entities.BulkOfflineConversion;
import com.microsoft.bingads.v12.bulk.entities.BulkPriceAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkProductAd;
import com.microsoft.bingads.v12.bulk.entities.BulkProductAdLabel;
import com.microsoft.bingads.v12.bulk.entities.BulkProductAudience;
import com.microsoft.bingads.v12.bulk.entities.BulkRemarketingList;
import com.microsoft.bingads.v12.bulk.entities.BulkResponsiveAd;
import com.microsoft.bingads.v12.bulk.entities.BulkResponsiveAdLabel;
import com.microsoft.bingads.v12.bulk.entities.BulkReviewAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkSharedNegativeKeyword;
import com.microsoft.bingads.v12.bulk.entities.BulkSitelinkAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkStructuredSnippetAdExtension;
import com.microsoft.bingads.v12.bulk.entities.BulkTextAd;
import com.microsoft.bingads.v12.bulk.entities.BulkTextAdLabel;
import com.microsoft.bingads.v12.bulk.entities.EntityInfo;
import com.microsoft.bingads.v12.bulk.entities.UnknownBulkEntity;
import com.microsoft.bingads.v12.internal.bulk.BulkObject;
import com.microsoft.bingads.v12.internal.bulk.BulkObjectFactory;
import com.microsoft.bingads.v12.internal.bulk.Creator;
import com.microsoft.bingads.v12.internal.bulk.FormatVersion;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.entities.BulkAdGroupNegativeSitesIdentifier;
import com.microsoft.bingads.v12.internal.bulk.entities.BulkCampaignNegativeSitesIdentifier;
import com.microsoft.bingads.v12.internal.bulk.entities.BulkEntityIdentifier;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StaticBulkObjectFactory
implements BulkObjectFactory {
    private static final Map<Class<? extends BulkObject>, String> TYPE_REVERSE_MAP;
    private static final Map<String, EntityInfo> INDIVIDUAL_ENTITY_MAP;
    private static final Map<String, Supplier<BulkObject>> ADDITIONAL_OBJECT_MAP;

    @Override
    public BulkObject createBulkObject(RowValues values) {
        String type = values.get("Type");
        if (type.endsWith("Error")) {
            return new BulkError();
        }
        if (ADDITIONAL_OBJECT_MAP.containsKey(type)) {
            return ADDITIONAL_OBJECT_MAP.get(type).get();
        }
        if (!INDIVIDUAL_ENTITY_MAP.containsKey(type)) {
            return new UnknownBulkEntity();
        }
        EntityInfo info = INDIVIDUAL_ENTITY_MAP.get(type);
        if ("Deleted".equals(values.get("Status")) && info.getDeleteAllColumnName() != null && !info.getDeleteAllColumnName().isEmpty() && (values.get(info.getDeleteAllColumnName()) == null || values.get(info.getDeleteAllColumnName()).isEmpty())) {
            return info.getIdentifierCreator().create();
        }
        return info.getCreator().create();
    }

    @Override
    public String getBulkRowType(BulkObject bulkObject) {
        if (bulkObject instanceof BulkError) {
            BulkError error = (BulkError)bulkObject;
            return this.getBulkRowType(error.getEntity()) + " Error";
        }
        return TYPE_REVERSE_MAP.get(bulkObject.getClass());
    }

    static {
        HashMap<String, EntityInfo> m = new HashMap<String, EntityInfo>();
        m.put("Account", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccount();
            }
        }));
        m.put("Campaign", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaign();
            }
        }));
        m.put("Ad Group", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroup();
            }
        }));
        m.put("Product Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkProductAd();
            }
        }));
        m.put("Text Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkTextAd();
            }
        }));
        m.put("App Install Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAppInstallAd();
            }
        }));
        m.put("Expanded Text Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkExpandedTextAd();
            }
        }));
        m.put("Dynamic Search Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkDynamicSearchAd();
            }
        }));
        m.put("Responsive Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkResponsiveAd();
            }
        }));
        m.put("Campaign Negative Dynamic Search Ad Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeDynamicSearchAdTarget();
            }
        }));
        m.put("Ad Group Negative Dynamic Search Ad Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeDynamicSearchAdTarget();
            }
        }));
        m.put("Ad Group Dynamic Search Ad Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupDynamicSearchAdTarget();
            }
        }));
        m.put("Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkKeyword();
            }
        }));
        m.put("Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkImageAdExtension();
            }
        }));
        m.put("Account Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountImageAdExtension();
            }
        }));
        m.put("Campaign Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignImageAdExtension();
            }
        }));
        m.put("Ad Group Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupImageAdExtension();
            }
        }));
        m.put("Location Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkLocationAdExtension();
            }
        }));
        m.put("Account Location Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountLocationAdExtension();
            }
        }));
        m.put("Campaign Location Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignLocationAdExtension();
            }
        }));
        m.put("Call Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCallAdExtension();
            }
        }));
        m.put("Campaign Call Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignCallAdExtension();
            }
        }));
        m.put("App Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAppAdExtension();
            }
        }));
        m.put("Account App Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountAppAdExtension();
            }
        }));
        m.put("Campaign App Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignAppAdExtension();
            }
        }));
        m.put("Ad Group App Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupAppAdExtension();
            }
        }));
        m.put("Callout Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCalloutAdExtension();
            }
        }));
        m.put("Account Callout Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountCalloutAdExtension();
            }
        }));
        m.put("Campaign Callout Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignCalloutAdExtension();
            }
        }));
        m.put("Ad Group Callout Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupCalloutAdExtension();
            }
        }));
        m.put("Price Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkPriceAdExtension();
            }
        }));
        m.put("Account Price Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountPriceAdExtension();
            }
        }));
        m.put("Campaign Price Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignPriceAdExtension();
            }
        }));
        m.put("Ad Group Price Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupPriceAdExtension();
            }
        }));
        m.put("Review Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkReviewAdExtension();
            }
        }));
        m.put("Account Review Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountReviewAdExtension();
            }
        }));
        m.put("Campaign Review Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignReviewAdExtension();
            }
        }));
        m.put("Ad Group Review Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupReviewAdExtension();
            }
        }));
        m.put("Sitelink Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkSitelinkAdExtension();
            }
        }));
        m.put("Account Sitelink Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountSitelinkAdExtension();
            }
        }));
        m.put("Campaign Sitelink Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignSitelinkAdExtension();
            }
        }));
        m.put("Ad Group Sitelink Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupSitelinkAdExtension();
            }
        }));
        m.put("Structured Snippet Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkStructuredSnippetAdExtension();
            }
        }));
        m.put("Account Structured Snippet Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountStructuredSnippetAdExtension();
            }
        }));
        m.put("Campaign Structured Snippet Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignStructuredSnippetAdExtension();
            }
        }));
        m.put("Ad Group Structured Snippet Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupStructuredSnippetAdExtension();
            }
        }));
        m.put("Campaign Negative Site", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeSite();
            }
        }, "Website", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkCampaignNegativeSitesIdentifier();
            }
        }));
        m.put("Ad Group Negative Site", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeSite();
            }
        }, "Website", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkAdGroupNegativeSitesIdentifier();
            }
        }));
        m.put("Campaign Product Scope", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignProductScope();
            }
        }));
        m.put("Ad Group Product Partition", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupProductPartition();
            }
        }));
        m.put("Campaign Negative Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeKeyword();
            }
        }));
        m.put("Ad Group Negative Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeKeyword();
            }
        }));
        m.put("Negative Keyword List", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkNegativeKeywordList();
            }
        }));
        m.put("Shared Negative Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkSharedNegativeKeyword();
            }
        }));
        m.put("Campaign Negative Keyword List Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeKeywordList();
            }
        }));
        m.put("Remarketing List", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkRemarketingList();
            }
        }));
        m.put("Ad Group Remarketing List Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupRemarketingListAssociation();
            }
        }));
        m.put("Ad Group Negative Remarketing List Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeRemarketingListAssociation();
            }
        }));
        m.put("Custom Audience", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCustomAudience();
            }
        }));
        m.put("Ad Group Custom Audience Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupCustomAudienceAssociation();
            }
        }));
        m.put("Ad Group Negative Custom Audience Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeCustomAudienceAssociation();
            }
        }));
        m.put("In Market Audience", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkInMarketAudience();
            }
        }));
        m.put("Ad Group In Market Audience Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupInMarketAudienceAssociation();
            }
        }));
        m.put("Ad Group Negative In Market Audience Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeInMarketAudienceAssociation();
            }
        }));
        m.put("Product Audience", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkProductAudience();
            }
        }));
        m.put("Ad Group Product Audience Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupProductAudienceAssociation();
            }
        }));
        m.put("Ad Group Negative Product Audience Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeProductAudienceAssociation();
            }
        }));
        m.put("Budget", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkBudget();
            }
        }));
        m.put("Ad Group Age Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupAgeCriterion();
            }
        }));
        m.put("Ad Group Company Name Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupCompanyNameCriterion();
            }
        }));
        m.put("Ad Group Industry Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupIndustryCriterion();
            }
        }));
        m.put("Ad Group Job Function Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupJobFunctionCriterion();
            }
        }));
        m.put("Ad Group DeviceOS Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupDeviceCriterion();
            }
        }));
        m.put("Ad Group DayTime Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupDayTimeCriterion();
            }
        }));
        m.put("Ad Group Radius Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupRadiusCriterion();
            }
        }));
        m.put("Ad Group Gender Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupGenderCriterion();
            }
        }));
        m.put("Ad Group Location Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupLocationCriterion();
            }
        }));
        m.put("Ad Group Location Intent Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupLocationIntentCriterion();
            }
        }));
        m.put("Ad Group Negative Location Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeLocationCriterion();
            }
        }));
        m.put("Ad Group Negative Age Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeAgeCriterion();
            }
        }));
        m.put("Ad Group Negative Company Name Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeCompanyNameCriterion();
            }
        }));
        m.put("Ad Group Negative Gender Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeGenderCriterion();
            }
        }));
        m.put("Ad Group Negative Industry Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeIndustryCriterion();
            }
        }));
        m.put("Ad Group Negative Job Function Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeJobFunctionCriterion();
            }
        }));
        m.put("Campaign Age Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignAgeCriterion();
            }
        }));
        m.put("Campaign Company Name Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignCompanyNameCriterion();
            }
        }));
        m.put("Campaign DeviceOS Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignDeviceCriterion();
            }
        }));
        m.put("Campaign DayTime Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignDayTimeCriterion();
            }
        }));
        m.put("Campaign Radius Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignRadiusCriterion();
            }
        }));
        m.put("Campaign Gender Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignGenderCriterion();
            }
        }));
        m.put("Campaign Industry Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignIndustryCriterion();
            }
        }));
        m.put("Campaign Job Function Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignJobFunctionCriterion();
            }
        }));
        m.put("Campaign Location Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignLocationCriterion();
            }
        }));
        m.put("Campaign Location Intent Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignLocationIntentCriterion();
            }
        }));
        m.put("Campaign Negative Location Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeLocationCriterion();
            }
        }));
        m.put("Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkLabel();
            }
        }));
        m.put("Campaign Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignLabel();
            }
        }));
        m.put("Ad Group Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupLabel();
            }
        }));
        m.put("Keyword Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkKeywordLabel();
            }
        }));
        m.put("App Install Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAppInstallAdLabel();
            }
        }));
        m.put("Dynamic Search Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkDynamicSearchAdLabel();
            }
        }));
        m.put("Expanded Text Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkExpandedTextAdLabel();
            }
        }));
        m.put("Product Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkProductAdLabel();
            }
        }));
        m.put("Responsive Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkResponsiveAdLabel();
            }
        }));
        m.put("Text Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkTextAdLabel();
            }
        }));
        m.put("Offline Conversion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkOfflineConversion();
            }
        }));
        INDIVIDUAL_ENTITY_MAP = Collections.unmodifiableMap(m);
        HashMap<String, Supplier<BulkObject>> addl = new HashMap<String, Supplier<BulkObject>>();
        addl.put("Keyword Best Position Bid", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new BulkKeywordBestPositionBid();
            }
        });
        addl.put("Keyword Main Line Bid", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new BulkKeywordMainLineBid();
            }
        });
        addl.put("Keyword First Page Bid", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new BulkKeywordFirstPageBid();
            }
        });
        addl.put("Format Version", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new FormatVersion();
            }
        });
        ADDITIONAL_OBJECT_MAP = Collections.unmodifiableMap(addl);
        HashMap c = new HashMap();
        for (Map.Entry<String, EntityInfo> entry : INDIVIDUAL_ENTITY_MAP.entrySet()) {
            c.put(entry.getValue().getCreator().create().getClass(), entry.getKey());
            if (entry.getValue().getIdentifierCreator() == null) continue;
            BulkEntityIdentifier identifier = entry.getValue().getIdentifierCreator().create();
            c.put(identifier.getClass(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : ADDITIONAL_OBJECT_MAP.entrySet()) {
            c.put(((BulkObject)((Supplier)entry.getValue()).get()).getClass(), entry.getKey());
        }
        TYPE_REVERSE_MAP = Collections.unmodifiableMap(c);
    }
}

