/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v11.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v11.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v11.campaignmanagement.LocationCriterion;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupLocationCriterion
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupLocationCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        LocationCriterion locationCriterion = new LocationCriterion();
        adGroupCriterion.setCriterion(locationCriterion);
        adGroupCriterion.getCriterion().setType(LocationCriterion.class.getSimpleName());
        adGroupCriterion.setCriterionBid(bidMultiplier);
        adGroupCriterion.setType("BiddableAdGroupCriterion");
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), BiddableAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion biddableAdGroupCriterion) {
        this.biddableAdGroupCriterion = biddableAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupLocationCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupLocationCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, String>("Status", new Function<BulkAdGroupLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationCriterion c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, Long>("Id", new Function<BulkAdGroupLocationCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupLocationCriterion c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, Long>("Parent Id", new Function<BulkAdGroupLocationCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupLocationCriterion c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, String>("Campaign", new Function<BulkAdGroupLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, String>("Ad Group", new Function<BulkAdGroupLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, String>("Bid Adjustment", new Function<BulkAdGroupLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getBiddableAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getBiddableAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, String>("Target", new Function<BulkAdGroupLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    Long locationId = ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getLocationId();
                    return locationId == null ? null : locationId.toString();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setLocationId(Long.parseLong(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, String>("Sub Type", new Function<BulkAdGroupLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getLocationType();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setLocationType(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, String>("Name", new Function<BulkAdGroupLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getDisplayName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setDisplayName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

